<?php

namespace EnumType;

/**
 * This class stands for enumCostCompensationType EnumType
 * @subpackage Enumerations
 */
class EnumCostCompensationType
{
    /**
     * Constant for value 'COST'
     * @return string 'COST'
     */
    const VALUE_COST = 'COST';
    /**
     * Constant for value 'COMPENSATION'
     * @return string 'COMPENSATION'
     */
    const VALUE_COMPENSATION = 'COMPENSATION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COST
     * @uses self::VALUE_COMPENSATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COST,
            self::VALUE_COMPENSATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
