<?php

namespace EnumType;

/**
 * This class stands for enumCivilState EnumType
 * @subpackage Enumerations
 */
class EnumCivilState
{
    /**
     * Constant for value 'MARRIED'
     * @return string 'MARRIED'
     */
    const VALUE_MARRIED = 'MARRIED';
    /**
     * Constant for value 'NOT_MARRIED'
     * @return string 'NOT_MARRIED'
     */
    const VALUE_NOT_MARRIED = 'NOT_MARRIED';
    /**
     * Constant for value 'WIDOW'
     * @return string 'WIDOW'
     */
    const VALUE_WIDOW = 'WIDOW';
    /**
     * Constant for value 'DIVORCED'
     * @return string 'DIVORCED'
     */
    const VALUE_DIVORCED = 'DIVORCED';
    /**
     * Constant for value 'LIVING_TOGETHER'
     * @return string 'LIVING_TOGETHER'
     */
    const VALUE_LIVING_TOGETHER = 'LIVING_TOGETHER';
    /**
     * Constant for value 'SINGLE'
     * @return string 'SINGLE'
     */
    const VALUE_SINGLE = 'SINGLE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MARRIED
     * @uses self::VALUE_NOT_MARRIED
     * @uses self::VALUE_WIDOW
     * @uses self::VALUE_DIVORCED
     * @uses self::VALUE_LIVING_TOGETHER
     * @uses self::VALUE_SINGLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MARRIED,
            self::VALUE_NOT_MARRIED,
            self::VALUE_WIDOW,
            self::VALUE_DIVORCED,
            self::VALUE_LIVING_TOGETHER,
            self::VALUE_SINGLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
