<?php

namespace EnumType;

/**
 * This class stands for enumCancelStatus EnumType
 * @subpackage Enumerations
 */
class EnumCancelStatus
{
    /**
     * Constant for value 'STILL_VALID'
     * @return string 'STILL_VALID'
     */
    const VALUE_STILL_VALID = 'STILL_VALID';
    /**
     * Constant for value 'PENDING'
     * @return string 'PENDING'
     */
    const VALUE_PENDING = 'PENDING';
    /**
     * Constant for value 'WAIT'
     * @return string 'WAIT'
     */
    const VALUE_WAIT = 'WAIT';
    /**
     * Constant for value 'REQUEST_TO_SEND'
     * @return string 'REQUEST_TO_SEND'
     */
    const VALUE_REQUEST_TO_SEND = 'REQUEST_TO_SEND';
    /**
     * Constant for value 'REQUEST'
     * @return string 'REQUEST'
     */
    const VALUE_REQUEST = 'REQUEST';
    /**
     * Constant for value 'REQUEST_FAIL'
     * @return string 'REQUEST_FAIL'
     */
    const VALUE_REQUEST_FAIL = 'REQUEST_FAIL';
    /**
     * Constant for value 'CANCELLED'
     * @return string 'CANCELLED'
     */
    const VALUE_CANCELLED = 'CANCELLED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STILL_VALID
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_WAIT
     * @uses self::VALUE_REQUEST_TO_SEND
     * @uses self::VALUE_REQUEST
     * @uses self::VALUE_REQUEST_FAIL
     * @uses self::VALUE_CANCELLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STILL_VALID,
            self::VALUE_PENDING,
            self::VALUE_WAIT,
            self::VALUE_REQUEST_TO_SEND,
            self::VALUE_REQUEST,
            self::VALUE_REQUEST_FAIL,
            self::VALUE_CANCELLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
