<?php

namespace EnumType;

/**
 * This class stands for enumAlarmMessageStatus EnumType
 * @subpackage Enumerations
 */
class EnumAlarmMessageStatus
{
    /**
     * Constant for value 'GIVE_NO_ALARM'
     * @return string 'GIVE_NO_ALARM'
     */
    const VALUE_GIVE_NO_ALARM = 'GIVE_NO_ALARM';
    /**
     * Constant for value 'GIVE_ALARM'
     * @return string 'GIVE_ALARM'
     */
    const VALUE_GIVE_ALARM = 'GIVE_ALARM';
    /**
     * Constant for value 'ALARM_NOT_READ_IN_TIME'
     * @return string 'ALARM_NOT_READ_IN_TIME'
     */
    const VALUE_ALARM_NOT_READ_IN_TIME = 'ALARM_NOT_READ_IN_TIME';
    /**
     * Constant for value 'ALARM_READ_IN_TIME'
     * @return string 'ALARM_READ_IN_TIME'
     */
    const VALUE_ALARM_READ_IN_TIME = 'ALARM_READ_IN_TIME';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GIVE_NO_ALARM
     * @uses self::VALUE_GIVE_ALARM
     * @uses self::VALUE_ALARM_NOT_READ_IN_TIME
     * @uses self::VALUE_ALARM_READ_IN_TIME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GIVE_NO_ALARM,
            self::VALUE_GIVE_ALARM,
            self::VALUE_ALARM_NOT_READ_IN_TIME,
            self::VALUE_ALARM_READ_IN_TIME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
