<?php

namespace EnumType;

/**
 * This class stands for CreationSource EnumType
 * @subpackage Enumerations
 */
class CreationSource
{
    /**
     * Constant for value 'Driver'
     * @return string 'Driver'
     */
    const VALUE_DRIVER = 'Driver';
    /**
     * Constant for value 'Dispatcher'
     * @return string 'Dispatcher'
     */
    const VALUE_DISPATCHER = 'Dispatcher';
    /**
     * Constant for value 'Planning'
     * @return string 'Planning'
     */
    const VALUE_PLANNING = 'Planning';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DRIVER
     * @uses self::VALUE_DISPATCHER
     * @uses self::VALUE_PLANNING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DRIVER,
            self::VALUE_DISPATCHER,
            self::VALUE_PLANNING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
