<?php

namespace EnumType;

/**
 * This class stands for CountryCodeTypes EnumType
 * @subpackage Enumerations
 */
class CountryCodeTypes
{
    /**
     * Constant for value 'TRANSICS'
     * @return string 'TRANSICS'
     */
    const VALUE_TRANSICS = 'TRANSICS';
    /**
     * Constant for value 'ALPHA_2'
     * @return string 'ALPHA_2'
     */
    const VALUE_ALPHA_2 = 'ALPHA_2';
    /**
     * Constant for value 'ALPHA_3'
     * @return string 'ALPHA_3'
     */
    const VALUE_ALPHA_3 = 'ALPHA_3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRANSICS
     * @uses self::VALUE_ALPHA_2
     * @uses self::VALUE_ALPHA_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRANSICS,
            self::VALUE_ALPHA_2,
            self::VALUE_ALPHA_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
