<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWorkDayItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfWorkDayItem extends AbstractStructArrayBase
{
    /**
     * The WorkDayItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WorkDayItem[]
     */
    public $WorkDayItem;
    /**
     * Constructor method for ArrayOfWorkDayItem
     * @uses ArrayOfWorkDayItem::setWorkDayItem()
     * @param \StructType\WorkDayItem[] $workDayItem
     */
    public function __construct(array $workDayItem = array())
    {
        $this
            ->setWorkDayItem($workDayItem);
    }
    /**
     * Get WorkDayItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WorkDayItem[]|null
     */
    public function getWorkDayItem()
    {
        return isset($this->WorkDayItem) ? $this->WorkDayItem : null;
    }
    /**
     * Set WorkDayItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WorkDayItem[] $workDayItem
     * @return \ArrayType\ArrayOfWorkDayItem
     */
    public function setWorkDayItem(array $workDayItem = array())
    {
        foreach ($workDayItem as $arrayOfWorkDayItemWorkDayItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfWorkDayItemWorkDayItemItem instanceof \StructType\WorkDayItem) {
                throw new \InvalidArgumentException(sprintf('The WorkDayItem property can only contain items of \StructType\WorkDayItem, "%s" given', is_object($arrayOfWorkDayItemWorkDayItemItem) ? get_class($arrayOfWorkDayItemWorkDayItemItem) : gettype($arrayOfWorkDayItemWorkDayItemItem)), __LINE__);
            }
        }
        if (is_null($workDayItem) || (is_array($workDayItem) && empty($workDayItem))) {
            unset($this->WorkDayItem);
        } else {
            $this->WorkDayItem = $workDayItem;
        }
        return $this;
    }
    /**
     * Add item to WorkDayItem value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkDayItem $item
     * @return \ArrayType\ArrayOfWorkDayItem
     */
    public function addToWorkDayItem(\StructType\WorkDayItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkDayItem) {
            throw new \InvalidArgumentException(sprintf('The WorkDayItem property can only contain items of \StructType\WorkDayItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WorkDayItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WorkDayItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WorkDayItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WorkDayItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WorkDayItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WorkDayItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WorkDayItem
     */
    public function getAttributeName()
    {
        return 'WorkDayItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfWorkDayItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
