<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVehicleGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfVehicleGroupItem extends AbstractStructArrayBase
{
    /**
     * The VehicleGroupItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\VehicleGroupItem[]
     */
    public $VehicleGroupItem;
    /**
     * Constructor method for ArrayOfVehicleGroupItem
     * @uses ArrayOfVehicleGroupItem::setVehicleGroupItem()
     * @param \StructType\VehicleGroupItem[] $vehicleGroupItem
     */
    public function __construct(array $vehicleGroupItem = array())
    {
        $this
            ->setVehicleGroupItem($vehicleGroupItem);
    }
    /**
     * Get VehicleGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VehicleGroupItem[]|null
     */
    public function getVehicleGroupItem()
    {
        return isset($this->VehicleGroupItem) ? $this->VehicleGroupItem : null;
    }
    /**
     * Set VehicleGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleGroupItem[] $vehicleGroupItem
     * @return \ArrayType\ArrayOfVehicleGroupItem
     */
    public function setVehicleGroupItem(array $vehicleGroupItem = array())
    {
        foreach ($vehicleGroupItem as $arrayOfVehicleGroupItemVehicleGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfVehicleGroupItemVehicleGroupItemItem instanceof \StructType\VehicleGroupItem) {
                throw new \InvalidArgumentException(sprintf('The VehicleGroupItem property can only contain items of \StructType\VehicleGroupItem, "%s" given', is_object($arrayOfVehicleGroupItemVehicleGroupItemItem) ? get_class($arrayOfVehicleGroupItemVehicleGroupItemItem) : gettype($arrayOfVehicleGroupItemVehicleGroupItemItem)), __LINE__);
            }
        }
        if (is_null($vehicleGroupItem) || (is_array($vehicleGroupItem) && empty($vehicleGroupItem))) {
            unset($this->VehicleGroupItem);
        } else {
            $this->VehicleGroupItem = $vehicleGroupItem;
        }
        return $this;
    }
    /**
     * Add item to VehicleGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleGroupItem $item
     * @return \ArrayType\ArrayOfVehicleGroupItem
     */
    public function addToVehicleGroupItem(\StructType\VehicleGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleGroupItem) {
            throw new \InvalidArgumentException(sprintf('The VehicleGroupItem property can only contain items of \StructType\VehicleGroupItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\VehicleGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\VehicleGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\VehicleGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\VehicleGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\VehicleGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string VehicleGroupItem
     */
    public function getAttributeName()
    {
        return 'VehicleGroupItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfVehicleGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
