<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTripResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfTripResult extends AbstractStructArrayBase
{
    /**
     * The TripResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TripResult[]
     */
    public $TripResult;
    /**
     * Constructor method for ArrayOfTripResult
     * @uses ArrayOfTripResult::setTripResult()
     * @param \StructType\TripResult[] $tripResult
     */
    public function __construct(array $tripResult = array())
    {
        $this
            ->setTripResult($tripResult);
    }
    /**
     * Get TripResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TripResult[]|null
     */
    public function getTripResult()
    {
        return isset($this->TripResult) ? $this->TripResult : null;
    }
    /**
     * Set TripResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TripResult[] $tripResult
     * @return \ArrayType\ArrayOfTripResult
     */
    public function setTripResult(array $tripResult = array())
    {
        foreach ($tripResult as $arrayOfTripResultTripResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTripResultTripResultItem instanceof \StructType\TripResult) {
                throw new \InvalidArgumentException(sprintf('The TripResult property can only contain items of \StructType\TripResult, "%s" given', is_object($arrayOfTripResultTripResultItem) ? get_class($arrayOfTripResultTripResultItem) : gettype($arrayOfTripResultTripResultItem)), __LINE__);
            }
        }
        if (is_null($tripResult) || (is_array($tripResult) && empty($tripResult))) {
            unset($this->TripResult);
        } else {
            $this->TripResult = $tripResult;
        }
        return $this;
    }
    /**
     * Add item to TripResult value
     * @throws \InvalidArgumentException
     * @param \StructType\TripResult $item
     * @return \ArrayType\ArrayOfTripResult
     */
    public function addToTripResult(\StructType\TripResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TripResult) {
            throw new \InvalidArgumentException(sprintf('The TripResult property can only contain items of \StructType\TripResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TripResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TripResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TripResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TripResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TripResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TripResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TripResult
     */
    public function getAttributeName()
    {
        return 'TripResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTripResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
