<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTripItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfTripItemResult extends AbstractStructArrayBase
{
    /**
     * The TripItemResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TripItemResult[]
     */
    public $TripItemResult;
    /**
     * Constructor method for ArrayOfTripItemResult
     * @uses ArrayOfTripItemResult::setTripItemResult()
     * @param \StructType\TripItemResult[] $tripItemResult
     */
    public function __construct(array $tripItemResult = array())
    {
        $this
            ->setTripItemResult($tripItemResult);
    }
    /**
     * Get TripItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TripItemResult[]|null
     */
    public function getTripItemResult()
    {
        return isset($this->TripItemResult) ? $this->TripItemResult : null;
    }
    /**
     * Set TripItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TripItemResult[] $tripItemResult
     * @return \ArrayType\ArrayOfTripItemResult
     */
    public function setTripItemResult(array $tripItemResult = array())
    {
        foreach ($tripItemResult as $arrayOfTripItemResultTripItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTripItemResultTripItemResultItem instanceof \StructType\TripItemResult) {
                throw new \InvalidArgumentException(sprintf('The TripItemResult property can only contain items of \StructType\TripItemResult, "%s" given', is_object($arrayOfTripItemResultTripItemResultItem) ? get_class($arrayOfTripItemResultTripItemResultItem) : gettype($arrayOfTripItemResultTripItemResultItem)), __LINE__);
            }
        }
        if (is_null($tripItemResult) || (is_array($tripItemResult) && empty($tripItemResult))) {
            unset($this->TripItemResult);
        } else {
            $this->TripItemResult = $tripItemResult;
        }
        return $this;
    }
    /**
     * Add item to TripItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\TripItemResult $item
     * @return \ArrayType\ArrayOfTripItemResult
     */
    public function addToTripItemResult(\StructType\TripItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TripItemResult) {
            throw new \InvalidArgumentException(sprintf('The TripItemResult property can only contain items of \StructType\TripItemResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TripItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TripItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TripItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TripItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TripItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TripItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TripItemResult
     */
    public function getAttributeName()
    {
        return 'TripItemResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTripItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
