<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrailerResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrailerResult extends AbstractStructArrayBase
{
    /**
     * The TrailerResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TrailerResult[]
     */
    public $TrailerResult;
    /**
     * Constructor method for ArrayOfTrailerResult
     * @uses ArrayOfTrailerResult::setTrailerResult()
     * @param \StructType\TrailerResult[] $trailerResult
     */
    public function __construct(array $trailerResult = array())
    {
        $this
            ->setTrailerResult($trailerResult);
    }
    /**
     * Get TrailerResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TrailerResult[]|null
     */
    public function getTrailerResult()
    {
        return isset($this->TrailerResult) ? $this->TrailerResult : null;
    }
    /**
     * Set TrailerResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerResult[] $trailerResult
     * @return \ArrayType\ArrayOfTrailerResult
     */
    public function setTrailerResult(array $trailerResult = array())
    {
        foreach ($trailerResult as $arrayOfTrailerResultTrailerResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrailerResultTrailerResultItem instanceof \StructType\TrailerResult) {
                throw new \InvalidArgumentException(sprintf('The TrailerResult property can only contain items of \StructType\TrailerResult, "%s" given', is_object($arrayOfTrailerResultTrailerResultItem) ? get_class($arrayOfTrailerResultTrailerResultItem) : gettype($arrayOfTrailerResultTrailerResultItem)), __LINE__);
            }
        }
        if (is_null($trailerResult) || (is_array($trailerResult) && empty($trailerResult))) {
            unset($this->TrailerResult);
        } else {
            $this->TrailerResult = $trailerResult;
        }
        return $this;
    }
    /**
     * Add item to TrailerResult value
     * @throws \InvalidArgumentException
     * @param \StructType\TrailerResult $item
     * @return \ArrayType\ArrayOfTrailerResult
     */
    public function addToTrailerResult(\StructType\TrailerResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrailerResult) {
            throw new \InvalidArgumentException(sprintf('The TrailerResult property can only contain items of \StructType\TrailerResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TrailerResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TrailerResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TrailerResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TrailerResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TrailerResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TrailerResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TrailerResult
     */
    public function getAttributeName()
    {
        return 'TrailerResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTrailerResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
