<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrackedDriver ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrackedDriver extends AbstractStructArrayBase
{
    /**
     * The TrackedDriver
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TrackedDriver[]
     */
    public $TrackedDriver;
    /**
     * Constructor method for ArrayOfTrackedDriver
     * @uses ArrayOfTrackedDriver::setTrackedDriver()
     * @param \StructType\TrackedDriver[] $trackedDriver
     */
    public function __construct(array $trackedDriver = array())
    {
        $this
            ->setTrackedDriver($trackedDriver);
    }
    /**
     * Get TrackedDriver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TrackedDriver[]|null
     */
    public function getTrackedDriver()
    {
        return isset($this->TrackedDriver) ? $this->TrackedDriver : null;
    }
    /**
     * Set TrackedDriver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TrackedDriver[] $trackedDriver
     * @return \ArrayType\ArrayOfTrackedDriver
     */
    public function setTrackedDriver(array $trackedDriver = array())
    {
        foreach ($trackedDriver as $arrayOfTrackedDriverTrackedDriverItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrackedDriverTrackedDriverItem instanceof \StructType\TrackedDriver) {
                throw new \InvalidArgumentException(sprintf('The TrackedDriver property can only contain items of \StructType\TrackedDriver, "%s" given', is_object($arrayOfTrackedDriverTrackedDriverItem) ? get_class($arrayOfTrackedDriverTrackedDriverItem) : gettype($arrayOfTrackedDriverTrackedDriverItem)), __LINE__);
            }
        }
        if (is_null($trackedDriver) || (is_array($trackedDriver) && empty($trackedDriver))) {
            unset($this->TrackedDriver);
        } else {
            $this->TrackedDriver = $trackedDriver;
        }
        return $this;
    }
    /**
     * Add item to TrackedDriver value
     * @throws \InvalidArgumentException
     * @param \StructType\TrackedDriver $item
     * @return \ArrayType\ArrayOfTrackedDriver
     */
    public function addToTrackedDriver(\StructType\TrackedDriver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TrackedDriver) {
            throw new \InvalidArgumentException(sprintf('The TrackedDriver property can only contain items of \StructType\TrackedDriver, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TrackedDriver[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TrackedDriver|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TrackedDriver|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TrackedDriver|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TrackedDriver|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TrackedDriver|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TrackedDriver
     */
    public function getAttributeName()
    {
        return 'TrackedDriver';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTrackedDriver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
