<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTextMessageInbox ArrayType
 * @subpackage Arrays
 */
class ArrayOfTextMessageInbox extends AbstractStructArrayBase
{
    /**
     * The TextMessageInbox
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TextMessageInbox[]
     */
    public $TextMessageInbox;
    /**
     * Constructor method for ArrayOfTextMessageInbox
     * @uses ArrayOfTextMessageInbox::setTextMessageInbox()
     * @param \StructType\TextMessageInbox[] $textMessageInbox
     */
    public function __construct(array $textMessageInbox = array())
    {
        $this
            ->setTextMessageInbox($textMessageInbox);
    }
    /**
     * Get TextMessageInbox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TextMessageInbox[]|null
     */
    public function getTextMessageInbox()
    {
        return isset($this->TextMessageInbox) ? $this->TextMessageInbox : null;
    }
    /**
     * Set TextMessageInbox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TextMessageInbox[] $textMessageInbox
     * @return \ArrayType\ArrayOfTextMessageInbox
     */
    public function setTextMessageInbox(array $textMessageInbox = array())
    {
        foreach ($textMessageInbox as $arrayOfTextMessageInboxTextMessageInboxItem) {
            // validation for constraint: itemType
            if (!$arrayOfTextMessageInboxTextMessageInboxItem instanceof \StructType\TextMessageInbox) {
                throw new \InvalidArgumentException(sprintf('The TextMessageInbox property can only contain items of \StructType\TextMessageInbox, "%s" given', is_object($arrayOfTextMessageInboxTextMessageInboxItem) ? get_class($arrayOfTextMessageInboxTextMessageInboxItem) : gettype($arrayOfTextMessageInboxTextMessageInboxItem)), __LINE__);
            }
        }
        if (is_null($textMessageInbox) || (is_array($textMessageInbox) && empty($textMessageInbox))) {
            unset($this->TextMessageInbox);
        } else {
            $this->TextMessageInbox = $textMessageInbox;
        }
        return $this;
    }
    /**
     * Add item to TextMessageInbox value
     * @throws \InvalidArgumentException
     * @param \StructType\TextMessageInbox $item
     * @return \ArrayType\ArrayOfTextMessageInbox
     */
    public function addToTextMessageInbox(\StructType\TextMessageInbox $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TextMessageInbox) {
            throw new \InvalidArgumentException(sprintf('The TextMessageInbox property can only contain items of \StructType\TextMessageInbox, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TextMessageInbox[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TextMessageInbox|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TextMessageInbox|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TextMessageInbox|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TextMessageInbox|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TextMessageInbox|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TextMessageInbox
     */
    public function getAttributeName()
    {
        return 'TextMessageInbox';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTextMessageInbox
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
