<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTemperatureInformation ArrayType
 * @subpackage Arrays
 */
class ArrayOfTemperatureInformation extends AbstractStructArrayBase
{
    /**
     * The TemperatureInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TemperatureInformation[]
     */
    public $TemperatureInformation;
    /**
     * Constructor method for ArrayOfTemperatureInformation
     * @uses ArrayOfTemperatureInformation::setTemperatureInformation()
     * @param \StructType\TemperatureInformation[] $temperatureInformation
     */
    public function __construct(array $temperatureInformation = array())
    {
        $this
            ->setTemperatureInformation($temperatureInformation);
    }
    /**
     * Get TemperatureInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TemperatureInformation[]|null
     */
    public function getTemperatureInformation()
    {
        return isset($this->TemperatureInformation) ? $this->TemperatureInformation : null;
    }
    /**
     * Set TemperatureInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureInformation[] $temperatureInformation
     * @return \ArrayType\ArrayOfTemperatureInformation
     */
    public function setTemperatureInformation(array $temperatureInformation = array())
    {
        foreach ($temperatureInformation as $arrayOfTemperatureInformationTemperatureInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfTemperatureInformationTemperatureInformationItem instanceof \StructType\TemperatureInformation) {
                throw new \InvalidArgumentException(sprintf('The TemperatureInformation property can only contain items of \StructType\TemperatureInformation, "%s" given', is_object($arrayOfTemperatureInformationTemperatureInformationItem) ? get_class($arrayOfTemperatureInformationTemperatureInformationItem) : gettype($arrayOfTemperatureInformationTemperatureInformationItem)), __LINE__);
            }
        }
        if (is_null($temperatureInformation) || (is_array($temperatureInformation) && empty($temperatureInformation))) {
            unset($this->TemperatureInformation);
        } else {
            $this->TemperatureInformation = $temperatureInformation;
        }
        return $this;
    }
    /**
     * Add item to TemperatureInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\TemperatureInformation $item
     * @return \ArrayType\ArrayOfTemperatureInformation
     */
    public function addToTemperatureInformation(\StructType\TemperatureInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TemperatureInformation) {
            throw new \InvalidArgumentException(sprintf('The TemperatureInformation property can only contain items of \StructType\TemperatureInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TemperatureInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TemperatureInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TemperatureInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TemperatureInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TemperatureInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TemperatureInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TemperatureInformation
     */
    public function getAttributeName()
    {
        return 'TemperatureInformation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTemperatureInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
