<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubGroupResultV2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfSubGroupResultV2 extends AbstractStructArrayBase
{
    /**
     * The SubGroupResultV2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SubGroupResultV2[]
     */
    public $SubGroupResultV2;
    /**
     * Constructor method for ArrayOfSubGroupResultV2
     * @uses ArrayOfSubGroupResultV2::setSubGroupResultV2()
     * @param \StructType\SubGroupResultV2[] $subGroupResultV2
     */
    public function __construct(array $subGroupResultV2 = array())
    {
        $this
            ->setSubGroupResultV2($subGroupResultV2);
    }
    /**
     * Get SubGroupResultV2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubGroupResultV2[]|null
     */
    public function getSubGroupResultV2()
    {
        return isset($this->SubGroupResultV2) ? $this->SubGroupResultV2 : null;
    }
    /**
     * Set SubGroupResultV2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroupResultV2[] $subGroupResultV2
     * @return \ArrayType\ArrayOfSubGroupResultV2
     */
    public function setSubGroupResultV2(array $subGroupResultV2 = array())
    {
        foreach ($subGroupResultV2 as $arrayOfSubGroupResultV2SubGroupResultV2Item) {
            // validation for constraint: itemType
            if (!$arrayOfSubGroupResultV2SubGroupResultV2Item instanceof \StructType\SubGroupResultV2) {
                throw new \InvalidArgumentException(sprintf('The SubGroupResultV2 property can only contain items of \StructType\SubGroupResultV2, "%s" given', is_object($arrayOfSubGroupResultV2SubGroupResultV2Item) ? get_class($arrayOfSubGroupResultV2SubGroupResultV2Item) : gettype($arrayOfSubGroupResultV2SubGroupResultV2Item)), __LINE__);
            }
        }
        if (is_null($subGroupResultV2) || (is_array($subGroupResultV2) && empty($subGroupResultV2))) {
            unset($this->SubGroupResultV2);
        } else {
            $this->SubGroupResultV2 = $subGroupResultV2;
        }
        return $this;
    }
    /**
     * Add item to SubGroupResultV2 value
     * @throws \InvalidArgumentException
     * @param \StructType\SubGroupResultV2 $item
     * @return \ArrayType\ArrayOfSubGroupResultV2
     */
    public function addToSubGroupResultV2(\StructType\SubGroupResultV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubGroupResultV2) {
            throw new \InvalidArgumentException(sprintf('The SubGroupResultV2 property can only contain items of \StructType\SubGroupResultV2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SubGroupResultV2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SubGroupResultV2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SubGroupResultV2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SubGroupResultV2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SubGroupResultV2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SubGroupResultV2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SubGroupResultV2
     */
    public function getAttributeName()
    {
        return 'SubGroupResultV2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSubGroupResultV2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
