<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfResourceIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfResourceIdentifier extends AbstractStructArrayBase
{
    /**
     * The ResourceIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResourceIdentifier[]
     */
    public $ResourceIdentifier;
    /**
     * Constructor method for ArrayOfResourceIdentifier
     * @uses ArrayOfResourceIdentifier::setResourceIdentifier()
     * @param \StructType\ResourceIdentifier[] $resourceIdentifier
     */
    public function __construct(array $resourceIdentifier = array())
    {
        $this
            ->setResourceIdentifier($resourceIdentifier);
    }
    /**
     * Get ResourceIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResourceIdentifier[]|null
     */
    public function getResourceIdentifier()
    {
        return isset($this->ResourceIdentifier) ? $this->ResourceIdentifier : null;
    }
    /**
     * Set ResourceIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ResourceIdentifier[] $resourceIdentifier
     * @return \ArrayType\ArrayOfResourceIdentifier
     */
    public function setResourceIdentifier(array $resourceIdentifier = array())
    {
        foreach ($resourceIdentifier as $arrayOfResourceIdentifierResourceIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfResourceIdentifierResourceIdentifierItem instanceof \StructType\ResourceIdentifier) {
                throw new \InvalidArgumentException(sprintf('The ResourceIdentifier property can only contain items of \StructType\ResourceIdentifier, "%s" given', is_object($arrayOfResourceIdentifierResourceIdentifierItem) ? get_class($arrayOfResourceIdentifierResourceIdentifierItem) : gettype($arrayOfResourceIdentifierResourceIdentifierItem)), __LINE__);
            }
        }
        if (is_null($resourceIdentifier) || (is_array($resourceIdentifier) && empty($resourceIdentifier))) {
            unset($this->ResourceIdentifier);
        } else {
            $this->ResourceIdentifier = $resourceIdentifier;
        }
        return $this;
    }
    /**
     * Add item to ResourceIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\ResourceIdentifier $item
     * @return \ArrayType\ArrayOfResourceIdentifier
     */
    public function addToResourceIdentifier(\StructType\ResourceIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResourceIdentifier) {
            throw new \InvalidArgumentException(sprintf('The ResourceIdentifier property can only contain items of \StructType\ResourceIdentifier, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ResourceIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ResourceIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ResourceIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ResourceIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ResourceIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ResourceIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ResourceIdentifier
     */
    public function getAttributeName()
    {
        return 'ResourceIdentifier';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfResourceIdentifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
