<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReferenceItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfReferenceItem extends AbstractStructArrayBase
{
    /**
     * The ReferenceItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReferenceItem[]
     */
    public $ReferenceItem;
    /**
     * Constructor method for ArrayOfReferenceItem
     * @uses ArrayOfReferenceItem::setReferenceItem()
     * @param \StructType\ReferenceItem[] $referenceItem
     */
    public function __construct(array $referenceItem = array())
    {
        $this
            ->setReferenceItem($referenceItem);
    }
    /**
     * Get ReferenceItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReferenceItem[]|null
     */
    public function getReferenceItem()
    {
        return isset($this->ReferenceItem) ? $this->ReferenceItem : null;
    }
    /**
     * Set ReferenceItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceItem[] $referenceItem
     * @return \ArrayType\ArrayOfReferenceItem
     */
    public function setReferenceItem(array $referenceItem = array())
    {
        foreach ($referenceItem as $arrayOfReferenceItemReferenceItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfReferenceItemReferenceItemItem instanceof \StructType\ReferenceItem) {
                throw new \InvalidArgumentException(sprintf('The ReferenceItem property can only contain items of \StructType\ReferenceItem, "%s" given', is_object($arrayOfReferenceItemReferenceItemItem) ? get_class($arrayOfReferenceItemReferenceItemItem) : gettype($arrayOfReferenceItemReferenceItemItem)), __LINE__);
            }
        }
        if (is_null($referenceItem) || (is_array($referenceItem) && empty($referenceItem))) {
            unset($this->ReferenceItem);
        } else {
            $this->ReferenceItem = $referenceItem;
        }
        return $this;
    }
    /**
     * Add item to ReferenceItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ReferenceItem $item
     * @return \ArrayType\ArrayOfReferenceItem
     */
    public function addToReferenceItem(\StructType\ReferenceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReferenceItem) {
            throw new \InvalidArgumentException(sprintf('The ReferenceItem property can only contain items of \StructType\ReferenceItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReferenceItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ReferenceItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ReferenceItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ReferenceItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ReferenceItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ReferenceItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReferenceItem
     */
    public function getAttributeName()
    {
        return 'ReferenceItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfReferenceItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
