<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfProductItemResult extends AbstractStructArrayBase
{
    /**
     * The ProductItemResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductItemResult[]
     */
    public $ProductItemResult;
    /**
     * Constructor method for ArrayOfProductItemResult
     * @uses ArrayOfProductItemResult::setProductItemResult()
     * @param \StructType\ProductItemResult[] $productItemResult
     */
    public function __construct(array $productItemResult = array())
    {
        $this
            ->setProductItemResult($productItemResult);
    }
    /**
     * Get ProductItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductItemResult[]|null
     */
    public function getProductItemResult()
    {
        return isset($this->ProductItemResult) ? $this->ProductItemResult : null;
    }
    /**
     * Set ProductItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItemResult[] $productItemResult
     * @return \ArrayType\ArrayOfProductItemResult
     */
    public function setProductItemResult(array $productItemResult = array())
    {
        foreach ($productItemResult as $arrayOfProductItemResultProductItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductItemResultProductItemResultItem instanceof \StructType\ProductItemResult) {
                throw new \InvalidArgumentException(sprintf('The ProductItemResult property can only contain items of \StructType\ProductItemResult, "%s" given', is_object($arrayOfProductItemResultProductItemResultItem) ? get_class($arrayOfProductItemResultProductItemResultItem) : gettype($arrayOfProductItemResultProductItemResultItem)), __LINE__);
            }
        }
        if (is_null($productItemResult) || (is_array($productItemResult) && empty($productItemResult))) {
            unset($this->ProductItemResult);
        } else {
            $this->ProductItemResult = $productItemResult;
        }
        return $this;
    }
    /**
     * Add item to ProductItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductItemResult $item
     * @return \ArrayType\ArrayOfProductItemResult
     */
    public function addToProductItemResult(\StructType\ProductItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductItemResult) {
            throw new \InvalidArgumentException(sprintf('The ProductItemResult property can only contain items of \StructType\ProductItemResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductItemResult
     */
    public function getAttributeName()
    {
        return 'ProductItemResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
