<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPositionItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPositionItemResult extends AbstractStructArrayBase
{
    /**
     * The PositionItemResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PositionItemResult[]
     */
    public $PositionItemResult;
    /**
     * Constructor method for ArrayOfPositionItemResult
     * @uses ArrayOfPositionItemResult::setPositionItemResult()
     * @param \StructType\PositionItemResult[] $positionItemResult
     */
    public function __construct(array $positionItemResult = array())
    {
        $this
            ->setPositionItemResult($positionItemResult);
    }
    /**
     * Get PositionItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PositionItemResult[]|null
     */
    public function getPositionItemResult()
    {
        return isset($this->PositionItemResult) ? $this->PositionItemResult : null;
    }
    /**
     * Set PositionItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PositionItemResult[] $positionItemResult
     * @return \ArrayType\ArrayOfPositionItemResult
     */
    public function setPositionItemResult(array $positionItemResult = array())
    {
        foreach ($positionItemResult as $arrayOfPositionItemResultPositionItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPositionItemResultPositionItemResultItem instanceof \StructType\PositionItemResult) {
                throw new \InvalidArgumentException(sprintf('The PositionItemResult property can only contain items of \StructType\PositionItemResult, "%s" given', is_object($arrayOfPositionItemResultPositionItemResultItem) ? get_class($arrayOfPositionItemResultPositionItemResultItem) : gettype($arrayOfPositionItemResultPositionItemResultItem)), __LINE__);
            }
        }
        if (is_null($positionItemResult) || (is_array($positionItemResult) && empty($positionItemResult))) {
            unset($this->PositionItemResult);
        } else {
            $this->PositionItemResult = $positionItemResult;
        }
        return $this;
    }
    /**
     * Add item to PositionItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PositionItemResult $item
     * @return \ArrayType\ArrayOfPositionItemResult
     */
    public function addToPositionItemResult(\StructType\PositionItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PositionItemResult) {
            throw new \InvalidArgumentException(sprintf('The PositionItemResult property can only contain items of \StructType\PositionItemResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PositionItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PositionItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PositionItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PositionItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PositionItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PositionItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PositionItemResult
     */
    public function getAttributeName()
    {
        return 'PositionItemResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPositionItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
