<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlanningConfigItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlanningConfigItem extends AbstractStructArrayBase
{
    /**
     * The PlanningConfigItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlanningConfigItem[]
     */
    public $PlanningConfigItem;
    /**
     * Constructor method for ArrayOfPlanningConfigItem
     * @uses ArrayOfPlanningConfigItem::setPlanningConfigItem()
     * @param \StructType\PlanningConfigItem[] $planningConfigItem
     */
    public function __construct(array $planningConfigItem = array())
    {
        $this
            ->setPlanningConfigItem($planningConfigItem);
    }
    /**
     * Get PlanningConfigItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlanningConfigItem[]|null
     */
    public function getPlanningConfigItem()
    {
        return isset($this->PlanningConfigItem) ? $this->PlanningConfigItem : null;
    }
    /**
     * Set PlanningConfigItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningConfigItem[] $planningConfigItem
     * @return \ArrayType\ArrayOfPlanningConfigItem
     */
    public function setPlanningConfigItem(array $planningConfigItem = array())
    {
        foreach ($planningConfigItem as $arrayOfPlanningConfigItemPlanningConfigItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlanningConfigItemPlanningConfigItemItem instanceof \StructType\PlanningConfigItem) {
                throw new \InvalidArgumentException(sprintf('The PlanningConfigItem property can only contain items of \StructType\PlanningConfigItem, "%s" given', is_object($arrayOfPlanningConfigItemPlanningConfigItemItem) ? get_class($arrayOfPlanningConfigItemPlanningConfigItemItem) : gettype($arrayOfPlanningConfigItemPlanningConfigItemItem)), __LINE__);
            }
        }
        if (is_null($planningConfigItem) || (is_array($planningConfigItem) && empty($planningConfigItem))) {
            unset($this->PlanningConfigItem);
        } else {
            $this->PlanningConfigItem = $planningConfigItem;
        }
        return $this;
    }
    /**
     * Add item to PlanningConfigItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PlanningConfigItem $item
     * @return \ArrayType\ArrayOfPlanningConfigItem
     */
    public function addToPlanningConfigItem(\StructType\PlanningConfigItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlanningConfigItem) {
            throw new \InvalidArgumentException(sprintf('The PlanningConfigItem property can only contain items of \StructType\PlanningConfigItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlanningConfigItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlanningConfigItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlanningConfigItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlanningConfigItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlanningConfigItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlanningConfigItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlanningConfigItem
     */
    public function getAttributeName()
    {
        return 'PlanningConfigItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPlanningConfigItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
