<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlaceResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlaceResult extends AbstractStructArrayBase
{
    /**
     * The PlaceResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlaceResult[]
     */
    public $PlaceResult;
    /**
     * Constructor method for ArrayOfPlaceResult
     * @uses ArrayOfPlaceResult::setPlaceResult()
     * @param \StructType\PlaceResult[] $placeResult
     */
    public function __construct(array $placeResult = array())
    {
        $this
            ->setPlaceResult($placeResult);
    }
    /**
     * Get PlaceResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlaceResult[]|null
     */
    public function getPlaceResult()
    {
        return isset($this->PlaceResult) ? $this->PlaceResult : null;
    }
    /**
     * Set PlaceResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceResult[] $placeResult
     * @return \ArrayType\ArrayOfPlaceResult
     */
    public function setPlaceResult(array $placeResult = array())
    {
        foreach ($placeResult as $arrayOfPlaceResultPlaceResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlaceResultPlaceResultItem instanceof \StructType\PlaceResult) {
                throw new \InvalidArgumentException(sprintf('The PlaceResult property can only contain items of \StructType\PlaceResult, "%s" given', is_object($arrayOfPlaceResultPlaceResultItem) ? get_class($arrayOfPlaceResultPlaceResultItem) : gettype($arrayOfPlaceResultPlaceResultItem)), __LINE__);
            }
        }
        if (is_null($placeResult) || (is_array($placeResult) && empty($placeResult))) {
            unset($this->PlaceResult);
        } else {
            $this->PlaceResult = $placeResult;
        }
        return $this;
    }
    /**
     * Add item to PlaceResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PlaceResult $item
     * @return \ArrayType\ArrayOfPlaceResult
     */
    public function addToPlaceResult(\StructType\PlaceResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlaceResult) {
            throw new \InvalidArgumentException(sprintf('The PlaceResult property can only contain items of \StructType\PlaceResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlaceResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlaceResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlaceResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlaceResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlaceResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlaceResult
     */
    public function getAttributeName()
    {
        return 'PlaceResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPlaceResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
