<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonResult_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonResult_V3 extends AbstractStructArrayBase
{
    /**
     * The PersonResult_V3
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonResult_V3[]
     */
    public $PersonResult_V3;
    /**
     * Constructor method for ArrayOfPersonResult_V3
     * @uses ArrayOfPersonResult_V3::setPersonResult_V3()
     * @param \StructType\PersonResult_V3[] $personResult_V3
     */
    public function __construct(array $personResult_V3 = array())
    {
        $this
            ->setPersonResult_V3($personResult_V3);
    }
    /**
     * Get PersonResult_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonResult_V3[]|null
     */
    public function getPersonResult_V3()
    {
        return isset($this->PersonResult_V3) ? $this->PersonResult_V3 : null;
    }
    /**
     * Set PersonResult_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V3[] $personResult_V3
     * @return \ArrayType\ArrayOfPersonResult_V3
     */
    public function setPersonResult_V3(array $personResult_V3 = array())
    {
        foreach ($personResult_V3 as $arrayOfPersonResult_V3PersonResult_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfPersonResult_V3PersonResult_V3Item instanceof \StructType\PersonResult_V3) {
                throw new \InvalidArgumentException(sprintf('The PersonResult_V3 property can only contain items of \StructType\PersonResult_V3, "%s" given', is_object($arrayOfPersonResult_V3PersonResult_V3Item) ? get_class($arrayOfPersonResult_V3PersonResult_V3Item) : gettype($arrayOfPersonResult_V3PersonResult_V3Item)), __LINE__);
            }
        }
        if (is_null($personResult_V3) || (is_array($personResult_V3) && empty($personResult_V3))) {
            unset($this->PersonResult_V3);
        } else {
            $this->PersonResult_V3 = $personResult_V3;
        }
        return $this;
    }
    /**
     * Add item to PersonResult_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult_V3 $item
     * @return \ArrayType\ArrayOfPersonResult_V3
     */
    public function addToPersonResult_V3(\StructType\PersonResult_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonResult_V3) {
            throw new \InvalidArgumentException(sprintf('The PersonResult_V3 property can only contain items of \StructType\PersonResult_V3, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PersonResult_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonResult_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonResult_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonResult_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonResult_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonResult_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonResult_V3
     */
    public function getAttributeName()
    {
        return 'PersonResult_V3';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPersonResult_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
