<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonResult extends AbstractStructArrayBase
{
    /**
     * The PersonResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonResult[]
     */
    public $PersonResult;
    /**
     * Constructor method for ArrayOfPersonResult
     * @uses ArrayOfPersonResult::setPersonResult()
     * @param \StructType\PersonResult[] $personResult
     */
    public function __construct(array $personResult = array())
    {
        $this
            ->setPersonResult($personResult);
    }
    /**
     * Get PersonResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonResult[]|null
     */
    public function getPersonResult()
    {
        return isset($this->PersonResult) ? $this->PersonResult : null;
    }
    /**
     * Set PersonResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult[] $personResult
     * @return \ArrayType\ArrayOfPersonResult
     */
    public function setPersonResult(array $personResult = array())
    {
        foreach ($personResult as $arrayOfPersonResultPersonResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonResultPersonResultItem instanceof \StructType\PersonResult) {
                throw new \InvalidArgumentException(sprintf('The PersonResult property can only contain items of \StructType\PersonResult, "%s" given', is_object($arrayOfPersonResultPersonResultItem) ? get_class($arrayOfPersonResultPersonResultItem) : gettype($arrayOfPersonResultPersonResultItem)), __LINE__);
            }
        }
        if (is_null($personResult) || (is_array($personResult) && empty($personResult))) {
            unset($this->PersonResult);
        } else {
            $this->PersonResult = $personResult;
        }
        return $this;
    }
    /**
     * Add item to PersonResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonResult $item
     * @return \ArrayType\ArrayOfPersonResult
     */
    public function addToPersonResult(\StructType\PersonResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonResult) {
            throw new \InvalidArgumentException(sprintf('The PersonResult property can only contain items of \StructType\PersonResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PersonResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonResult
     */
    public function getAttributeName()
    {
        return 'PersonResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPersonResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
