<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPathResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfPathResult extends AbstractStructArrayBase
{
    /**
     * The PathResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PathResult[]
     */
    public $PathResult;
    /**
     * Constructor method for ArrayOfPathResult
     * @uses ArrayOfPathResult::setPathResult()
     * @param \StructType\PathResult[] $pathResult
     */
    public function __construct(array $pathResult = array())
    {
        $this
            ->setPathResult($pathResult);
    }
    /**
     * Get PathResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PathResult[]|null
     */
    public function getPathResult()
    {
        return isset($this->PathResult) ? $this->PathResult : null;
    }
    /**
     * Set PathResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PathResult[] $pathResult
     * @return \ArrayType\ArrayOfPathResult
     */
    public function setPathResult(array $pathResult = array())
    {
        foreach ($pathResult as $arrayOfPathResultPathResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfPathResultPathResultItem instanceof \StructType\PathResult) {
                throw new \InvalidArgumentException(sprintf('The PathResult property can only contain items of \StructType\PathResult, "%s" given', is_object($arrayOfPathResultPathResultItem) ? get_class($arrayOfPathResultPathResultItem) : gettype($arrayOfPathResultPathResultItem)), __LINE__);
            }
        }
        if (is_null($pathResult) || (is_array($pathResult) && empty($pathResult))) {
            unset($this->PathResult);
        } else {
            $this->PathResult = $pathResult;
        }
        return $this;
    }
    /**
     * Add item to PathResult value
     * @throws \InvalidArgumentException
     * @param \StructType\PathResult $item
     * @return \ArrayType\ArrayOfPathResult
     */
    public function addToPathResult(\StructType\PathResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PathResult) {
            throw new \InvalidArgumentException(sprintf('The PathResult property can only contain items of \StructType\PathResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PathResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PathResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PathResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PathResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PathResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PathResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PathResult
     */
    public function getAttributeName()
    {
        return 'PathResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPathResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
