<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPalletReportItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfPalletReportItem extends AbstractStructArrayBase
{
    /**
     * The PalletReportItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PalletReportItem[]
     */
    public $PalletReportItem;
    /**
     * Constructor method for ArrayOfPalletReportItem
     * @uses ArrayOfPalletReportItem::setPalletReportItem()
     * @param \StructType\PalletReportItem[] $palletReportItem
     */
    public function __construct(array $palletReportItem = array())
    {
        $this
            ->setPalletReportItem($palletReportItem);
    }
    /**
     * Get PalletReportItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PalletReportItem[]|null
     */
    public function getPalletReportItem()
    {
        return isset($this->PalletReportItem) ? $this->PalletReportItem : null;
    }
    /**
     * Set PalletReportItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PalletReportItem[] $palletReportItem
     * @return \ArrayType\ArrayOfPalletReportItem
     */
    public function setPalletReportItem(array $palletReportItem = array())
    {
        foreach ($palletReportItem as $arrayOfPalletReportItemPalletReportItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfPalletReportItemPalletReportItemItem instanceof \StructType\PalletReportItem) {
                throw new \InvalidArgumentException(sprintf('The PalletReportItem property can only contain items of \StructType\PalletReportItem, "%s" given', is_object($arrayOfPalletReportItemPalletReportItemItem) ? get_class($arrayOfPalletReportItemPalletReportItemItem) : gettype($arrayOfPalletReportItemPalletReportItemItem)), __LINE__);
            }
        }
        if (is_null($palletReportItem) || (is_array($palletReportItem) && empty($palletReportItem))) {
            unset($this->PalletReportItem);
        } else {
            $this->PalletReportItem = $palletReportItem;
        }
        return $this;
    }
    /**
     * Add item to PalletReportItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PalletReportItem $item
     * @return \ArrayType\ArrayOfPalletReportItem
     */
    public function addToPalletReportItem(\StructType\PalletReportItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PalletReportItem) {
            throw new \InvalidArgumentException(sprintf('The PalletReportItem property can only contain items of \StructType\PalletReportItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PalletReportItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PalletReportItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PalletReportItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PalletReportItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PalletReportItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PalletReportItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PalletReportItem
     */
    public function getAttributeName()
    {
        return 'PalletReportItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPalletReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
