<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNearestPositionItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfNearestPositionItem extends AbstractStructArrayBase
{
    /**
     * The NearestPositionItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NearestPositionItem[]
     */
    public $NearestPositionItem;
    /**
     * Constructor method for ArrayOfNearestPositionItem
     * @uses ArrayOfNearestPositionItem::setNearestPositionItem()
     * @param \StructType\NearestPositionItem[] $nearestPositionItem
     */
    public function __construct(array $nearestPositionItem = array())
    {
        $this
            ->setNearestPositionItem($nearestPositionItem);
    }
    /**
     * Get NearestPositionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NearestPositionItem[]|null
     */
    public function getNearestPositionItem()
    {
        return isset($this->NearestPositionItem) ? $this->NearestPositionItem : null;
    }
    /**
     * Set NearestPositionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NearestPositionItem[] $nearestPositionItem
     * @return \ArrayType\ArrayOfNearestPositionItem
     */
    public function setNearestPositionItem(array $nearestPositionItem = array())
    {
        foreach ($nearestPositionItem as $arrayOfNearestPositionItemNearestPositionItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfNearestPositionItemNearestPositionItemItem instanceof \StructType\NearestPositionItem) {
                throw new \InvalidArgumentException(sprintf('The NearestPositionItem property can only contain items of \StructType\NearestPositionItem, "%s" given', is_object($arrayOfNearestPositionItemNearestPositionItemItem) ? get_class($arrayOfNearestPositionItemNearestPositionItemItem) : gettype($arrayOfNearestPositionItemNearestPositionItemItem)), __LINE__);
            }
        }
        if (is_null($nearestPositionItem) || (is_array($nearestPositionItem) && empty($nearestPositionItem))) {
            unset($this->NearestPositionItem);
        } else {
            $this->NearestPositionItem = $nearestPositionItem;
        }
        return $this;
    }
    /**
     * Add item to NearestPositionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\NearestPositionItem $item
     * @return \ArrayType\ArrayOfNearestPositionItem
     */
    public function addToNearestPositionItem(\StructType\NearestPositionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NearestPositionItem) {
            throw new \InvalidArgumentException(sprintf('The NearestPositionItem property can only contain items of \StructType\NearestPositionItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NearestPositionItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NearestPositionItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NearestPositionItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NearestPositionItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NearestPositionItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NearestPositionItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NearestPositionItem
     */
    public function getAttributeName()
    {
        return 'NearestPositionItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNearestPositionItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
