<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapRoute ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapRoute extends AbstractStructArrayBase
{
    /**
     * The MapRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapRoute[]
     */
    public $MapRoute;
    /**
     * Constructor method for ArrayOfMapRoute
     * @uses ArrayOfMapRoute::setMapRoute()
     * @param \StructType\MapRoute[] $mapRoute
     */
    public function __construct(array $mapRoute = array())
    {
        $this
            ->setMapRoute($mapRoute);
    }
    /**
     * Get MapRoute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapRoute[]|null
     */
    public function getMapRoute()
    {
        return isset($this->MapRoute) ? $this->MapRoute : null;
    }
    /**
     * Set MapRoute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapRoute[] $mapRoute
     * @return \ArrayType\ArrayOfMapRoute
     */
    public function setMapRoute(array $mapRoute = array())
    {
        foreach ($mapRoute as $arrayOfMapRouteMapRouteItem) {
            // validation for constraint: itemType
            if (!$arrayOfMapRouteMapRouteItem instanceof \StructType\MapRoute) {
                throw new \InvalidArgumentException(sprintf('The MapRoute property can only contain items of \StructType\MapRoute, "%s" given', is_object($arrayOfMapRouteMapRouteItem) ? get_class($arrayOfMapRouteMapRouteItem) : gettype($arrayOfMapRouteMapRouteItem)), __LINE__);
            }
        }
        if (is_null($mapRoute) || (is_array($mapRoute) && empty($mapRoute))) {
            unset($this->MapRoute);
        } else {
            $this->MapRoute = $mapRoute;
        }
        return $this;
    }
    /**
     * Add item to MapRoute value
     * @throws \InvalidArgumentException
     * @param \StructType\MapRoute $item
     * @return \ArrayType\ArrayOfMapRoute
     */
    public function addToMapRoute(\StructType\MapRoute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapRoute) {
            throw new \InvalidArgumentException(sprintf('The MapRoute property can only contain items of \StructType\MapRoute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MapRoute[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapRoute|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapRoute|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapRoute|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapRoute|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapRoute|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapRoute
     */
    public function getAttributeName()
    {
        return 'MapRoute';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMapRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
