<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapPosition_V2 ArrayType
 * @subpackage Arrays
 */
class ArrayOfMapPosition_V2 extends AbstractStructArrayBase
{
    /**
     * The MapPosition_V2
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MapPosition_V2[]
     */
    public $MapPosition_V2;
    /**
     * Constructor method for ArrayOfMapPosition_V2
     * @uses ArrayOfMapPosition_V2::setMapPosition_V2()
     * @param \StructType\MapPosition_V2[] $mapPosition_V2
     */
    public function __construct(array $mapPosition_V2 = array())
    {
        $this
            ->setMapPosition_V2($mapPosition_V2);
    }
    /**
     * Get MapPosition_V2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MapPosition_V2[]|null
     */
    public function getMapPosition_V2()
    {
        return isset($this->MapPosition_V2) ? $this->MapPosition_V2 : null;
    }
    /**
     * Set MapPosition_V2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MapPosition_V2[] $mapPosition_V2
     * @return \ArrayType\ArrayOfMapPosition_V2
     */
    public function setMapPosition_V2(array $mapPosition_V2 = array())
    {
        foreach ($mapPosition_V2 as $arrayOfMapPosition_V2MapPosition_V2Item) {
            // validation for constraint: itemType
            if (!$arrayOfMapPosition_V2MapPosition_V2Item instanceof \StructType\MapPosition_V2) {
                throw new \InvalidArgumentException(sprintf('The MapPosition_V2 property can only contain items of \StructType\MapPosition_V2, "%s" given', is_object($arrayOfMapPosition_V2MapPosition_V2Item) ? get_class($arrayOfMapPosition_V2MapPosition_V2Item) : gettype($arrayOfMapPosition_V2MapPosition_V2Item)), __LINE__);
            }
        }
        if (is_null($mapPosition_V2) || (is_array($mapPosition_V2) && empty($mapPosition_V2))) {
            unset($this->MapPosition_V2);
        } else {
            $this->MapPosition_V2 = $mapPosition_V2;
        }
        return $this;
    }
    /**
     * Add item to MapPosition_V2 value
     * @throws \InvalidArgumentException
     * @param \StructType\MapPosition_V2 $item
     * @return \ArrayType\ArrayOfMapPosition_V2
     */
    public function addToMapPosition_V2(\StructType\MapPosition_V2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MapPosition_V2) {
            throw new \InvalidArgumentException(sprintf('The MapPosition_V2 property can only contain items of \StructType\MapPosition_V2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MapPosition_V2[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MapPosition_V2|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MapPosition_V2|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MapPosition_V2|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MapPosition_V2|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MapPosition_V2|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapPosition_V2
     */
    public function getAttributeName()
    {
        return 'MapPosition_V2';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMapPosition_V2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
