<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJobItemResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfJobItemResult extends AbstractStructArrayBase
{
    /**
     * The JobItemResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\JobItemResult[]
     */
    public $JobItemResult;
    /**
     * Constructor method for ArrayOfJobItemResult
     * @uses ArrayOfJobItemResult::setJobItemResult()
     * @param \StructType\JobItemResult[] $jobItemResult
     */
    public function __construct(array $jobItemResult = array())
    {
        $this
            ->setJobItemResult($jobItemResult);
    }
    /**
     * Get JobItemResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\JobItemResult[]|null
     */
    public function getJobItemResult()
    {
        return isset($this->JobItemResult) ? $this->JobItemResult : null;
    }
    /**
     * Set JobItemResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult[] $jobItemResult
     * @return \ArrayType\ArrayOfJobItemResult
     */
    public function setJobItemResult(array $jobItemResult = array())
    {
        foreach ($jobItemResult as $arrayOfJobItemResultJobItemResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobItemResultJobItemResultItem instanceof \StructType\JobItemResult) {
                throw new \InvalidArgumentException(sprintf('The JobItemResult property can only contain items of \StructType\JobItemResult, "%s" given', is_object($arrayOfJobItemResultJobItemResultItem) ? get_class($arrayOfJobItemResultJobItemResultItem) : gettype($arrayOfJobItemResultJobItemResultItem)), __LINE__);
            }
        }
        if (is_null($jobItemResult) || (is_array($jobItemResult) && empty($jobItemResult))) {
            unset($this->JobItemResult);
        } else {
            $this->JobItemResult = $jobItemResult;
        }
        return $this;
    }
    /**
     * Add item to JobItemResult value
     * @throws \InvalidArgumentException
     * @param \StructType\JobItemResult $item
     * @return \ArrayType\ArrayOfJobItemResult
     */
    public function addToJobItemResult(\StructType\JobItemResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobItemResult) {
            throw new \InvalidArgumentException(sprintf('The JobItemResult property can only contain items of \StructType\JobItemResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JobItemResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JobItemResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JobItemResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JobItemResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JobItemResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JobItemResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string JobItemResult
     */
    public function getAttributeName()
    {
        return 'JobItemResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJobItemResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
