<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInfringementCodeItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfInfringementCodeItem extends AbstractStructArrayBase
{
    /**
     * The InfringementCodeItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InfringementCodeItem[]
     */
    public $InfringementCodeItem;
    /**
     * Constructor method for ArrayOfInfringementCodeItem
     * @uses ArrayOfInfringementCodeItem::setInfringementCodeItem()
     * @param \StructType\InfringementCodeItem[] $infringementCodeItem
     */
    public function __construct(array $infringementCodeItem = array())
    {
        $this
            ->setInfringementCodeItem($infringementCodeItem);
    }
    /**
     * Get InfringementCodeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InfringementCodeItem[]|null
     */
    public function getInfringementCodeItem()
    {
        return isset($this->InfringementCodeItem) ? $this->InfringementCodeItem : null;
    }
    /**
     * Set InfringementCodeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InfringementCodeItem[] $infringementCodeItem
     * @return \ArrayType\ArrayOfInfringementCodeItem
     */
    public function setInfringementCodeItem(array $infringementCodeItem = array())
    {
        foreach ($infringementCodeItem as $arrayOfInfringementCodeItemInfringementCodeItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfInfringementCodeItemInfringementCodeItemItem instanceof \StructType\InfringementCodeItem) {
                throw new \InvalidArgumentException(sprintf('The InfringementCodeItem property can only contain items of \StructType\InfringementCodeItem, "%s" given', is_object($arrayOfInfringementCodeItemInfringementCodeItemItem) ? get_class($arrayOfInfringementCodeItemInfringementCodeItemItem) : gettype($arrayOfInfringementCodeItemInfringementCodeItemItem)), __LINE__);
            }
        }
        if (is_null($infringementCodeItem) || (is_array($infringementCodeItem) && empty($infringementCodeItem))) {
            unset($this->InfringementCodeItem);
        } else {
            $this->InfringementCodeItem = $infringementCodeItem;
        }
        return $this;
    }
    /**
     * Add item to InfringementCodeItem value
     * @throws \InvalidArgumentException
     * @param \StructType\InfringementCodeItem $item
     * @return \ArrayType\ArrayOfInfringementCodeItem
     */
    public function addToInfringementCodeItem(\StructType\InfringementCodeItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InfringementCodeItem) {
            throw new \InvalidArgumentException(sprintf('The InfringementCodeItem property can only contain items of \StructType\InfringementCodeItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InfringementCodeItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InfringementCodeItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InfringementCodeItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InfringementCodeItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InfringementCodeItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InfringementCodeItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InfringementCodeItem
     */
    public function getAttributeName()
    {
        return 'InfringementCodeItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInfringementCodeItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
