<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifierResult ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifierResult extends AbstractStructArrayBase
{
    /**
     * The IdentifierResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentifierResult[]
     */
    public $IdentifierResult;
    /**
     * Constructor method for ArrayOfIdentifierResult
     * @uses ArrayOfIdentifierResult::setIdentifierResult()
     * @param \StructType\IdentifierResult[] $identifierResult
     */
    public function __construct(array $identifierResult = array())
    {
        $this
            ->setIdentifierResult($identifierResult);
    }
    /**
     * Get IdentifierResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentifierResult[]|null
     */
    public function getIdentifierResult()
    {
        return isset($this->IdentifierResult) ? $this->IdentifierResult : null;
    }
    /**
     * Set IdentifierResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierResult[] $identifierResult
     * @return \ArrayType\ArrayOfIdentifierResult
     */
    public function setIdentifierResult(array $identifierResult = array())
    {
        foreach ($identifierResult as $arrayOfIdentifierResultIdentifierResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierResultIdentifierResultItem instanceof \StructType\IdentifierResult) {
                throw new \InvalidArgumentException(sprintf('The IdentifierResult property can only contain items of \StructType\IdentifierResult, "%s" given', is_object($arrayOfIdentifierResultIdentifierResultItem) ? get_class($arrayOfIdentifierResultIdentifierResultItem) : gettype($arrayOfIdentifierResultIdentifierResultItem)), __LINE__);
            }
        }
        if (is_null($identifierResult) || (is_array($identifierResult) && empty($identifierResult))) {
            unset($this->IdentifierResult);
        } else {
            $this->IdentifierResult = $identifierResult;
        }
        return $this;
    }
    /**
     * Add item to IdentifierResult value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierResult $item
     * @return \ArrayType\ArrayOfIdentifierResult
     */
    public function addToIdentifierResult(\StructType\IdentifierResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierResult) {
            throw new \InvalidArgumentException(sprintf('The IdentifierResult property can only contain items of \StructType\IdentifierResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IdentifierResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdentifierResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdentifierResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdentifierResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdentifierResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdentifierResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdentifierResult
     */
    public function getAttributeName()
    {
        return 'IdentifierResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIdentifierResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
