<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIdentifierPerson ArrayType
 * @subpackage Arrays
 */
class ArrayOfIdentifierPerson extends AbstractStructArrayBase
{
    /**
     * The IdentifierPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IdentifierPerson[]
     */
    public $IdentifierPerson;
    /**
     * Constructor method for ArrayOfIdentifierPerson
     * @uses ArrayOfIdentifierPerson::setIdentifierPerson()
     * @param \StructType\IdentifierPerson[] $identifierPerson
     */
    public function __construct(array $identifierPerson = array())
    {
        $this
            ->setIdentifierPerson($identifierPerson);
    }
    /**
     * Get IdentifierPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IdentifierPerson[]|null
     */
    public function getIdentifierPerson()
    {
        return isset($this->IdentifierPerson) ? $this->IdentifierPerson : null;
    }
    /**
     * Set IdentifierPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierPerson[] $identifierPerson
     * @return \ArrayType\ArrayOfIdentifierPerson
     */
    public function setIdentifierPerson(array $identifierPerson = array())
    {
        foreach ($identifierPerson as $arrayOfIdentifierPersonIdentifierPersonItem) {
            // validation for constraint: itemType
            if (!$arrayOfIdentifierPersonIdentifierPersonItem instanceof \StructType\IdentifierPerson) {
                throw new \InvalidArgumentException(sprintf('The IdentifierPerson property can only contain items of \StructType\IdentifierPerson, "%s" given', is_object($arrayOfIdentifierPersonIdentifierPersonItem) ? get_class($arrayOfIdentifierPersonIdentifierPersonItem) : gettype($arrayOfIdentifierPersonIdentifierPersonItem)), __LINE__);
            }
        }
        if (is_null($identifierPerson) || (is_array($identifierPerson) && empty($identifierPerson))) {
            unset($this->IdentifierPerson);
        } else {
            $this->IdentifierPerson = $identifierPerson;
        }
        return $this;
    }
    /**
     * Add item to IdentifierPerson value
     * @throws \InvalidArgumentException
     * @param \StructType\IdentifierPerson $item
     * @return \ArrayType\ArrayOfIdentifierPerson
     */
    public function addToIdentifierPerson(\StructType\IdentifierPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IdentifierPerson) {
            throw new \InvalidArgumentException(sprintf('The IdentifierPerson property can only contain items of \StructType\IdentifierPerson, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IdentifierPerson[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IdentifierPerson|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IdentifierPerson|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IdentifierPerson|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IdentifierPerson|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IdentifierPerson|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IdentifierPerson
     */
    public function getAttributeName()
    {
        return 'IdentifierPerson';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIdentifierPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
