<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGenericItem_V1 ArrayType
 * @subpackage Arrays
 */
class ArrayOfGenericItem_V1 extends AbstractStructArrayBase
{
    /**
     * The GenericItem_V1
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GenericItem_V1[]
     */
    public $GenericItem_V1;
    /**
     * Constructor method for ArrayOfGenericItem_V1
     * @uses ArrayOfGenericItem_V1::setGenericItem_V1()
     * @param \StructType\GenericItem_V1[] $genericItem_V1
     */
    public function __construct(array $genericItem_V1 = array())
    {
        $this
            ->setGenericItem_V1($genericItem_V1);
    }
    /**
     * Get GenericItem_V1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GenericItem_V1[]|null
     */
    public function getGenericItem_V1()
    {
        return isset($this->GenericItem_V1) ? $this->GenericItem_V1 : null;
    }
    /**
     * Set GenericItem_V1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem_V1[] $genericItem_V1
     * @return \ArrayType\ArrayOfGenericItem_V1
     */
    public function setGenericItem_V1(array $genericItem_V1 = array())
    {
        foreach ($genericItem_V1 as $arrayOfGenericItem_V1GenericItem_V1Item) {
            // validation for constraint: itemType
            if (!$arrayOfGenericItem_V1GenericItem_V1Item instanceof \StructType\GenericItem_V1) {
                throw new \InvalidArgumentException(sprintf('The GenericItem_V1 property can only contain items of \StructType\GenericItem_V1, "%s" given', is_object($arrayOfGenericItem_V1GenericItem_V1Item) ? get_class($arrayOfGenericItem_V1GenericItem_V1Item) : gettype($arrayOfGenericItem_V1GenericItem_V1Item)), __LINE__);
            }
        }
        if (is_null($genericItem_V1) || (is_array($genericItem_V1) && empty($genericItem_V1))) {
            unset($this->GenericItem_V1);
        } else {
            $this->GenericItem_V1 = $genericItem_V1;
        }
        return $this;
    }
    /**
     * Add item to GenericItem_V1 value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericItem_V1 $item
     * @return \ArrayType\ArrayOfGenericItem_V1
     */
    public function addToGenericItem_V1(\StructType\GenericItem_V1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericItem_V1) {
            throw new \InvalidArgumentException(sprintf('The GenericItem_V1 property can only contain items of \StructType\GenericItem_V1, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GenericItem_V1[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\GenericItem_V1|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\GenericItem_V1|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\GenericItem_V1|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\GenericItem_V1|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\GenericItem_V1|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string GenericItem_V1
     */
    public function getAttributeName()
    {
        return 'GenericItem_V1';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGenericItem_V1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
