<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFuelReportItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfFuelReportItem extends AbstractStructArrayBase
{
    /**
     * The FuelReportItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FuelReportItem[]
     */
    public $FuelReportItem;
    /**
     * Constructor method for ArrayOfFuelReportItem
     * @uses ArrayOfFuelReportItem::setFuelReportItem()
     * @param \StructType\FuelReportItem[] $fuelReportItem
     */
    public function __construct(array $fuelReportItem = array())
    {
        $this
            ->setFuelReportItem($fuelReportItem);
    }
    /**
     * Get FuelReportItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FuelReportItem[]|null
     */
    public function getFuelReportItem()
    {
        return isset($this->FuelReportItem) ? $this->FuelReportItem : null;
    }
    /**
     * Set FuelReportItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FuelReportItem[] $fuelReportItem
     * @return \ArrayType\ArrayOfFuelReportItem
     */
    public function setFuelReportItem(array $fuelReportItem = array())
    {
        foreach ($fuelReportItem as $arrayOfFuelReportItemFuelReportItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfFuelReportItemFuelReportItemItem instanceof \StructType\FuelReportItem) {
                throw new \InvalidArgumentException(sprintf('The FuelReportItem property can only contain items of \StructType\FuelReportItem, "%s" given', is_object($arrayOfFuelReportItemFuelReportItemItem) ? get_class($arrayOfFuelReportItemFuelReportItemItem) : gettype($arrayOfFuelReportItemFuelReportItemItem)), __LINE__);
            }
        }
        if (is_null($fuelReportItem) || (is_array($fuelReportItem) && empty($fuelReportItem))) {
            unset($this->FuelReportItem);
        } else {
            $this->FuelReportItem = $fuelReportItem;
        }
        return $this;
    }
    /**
     * Add item to FuelReportItem value
     * @throws \InvalidArgumentException
     * @param \StructType\FuelReportItem $item
     * @return \ArrayType\ArrayOfFuelReportItem
     */
    public function addToFuelReportItem(\StructType\FuelReportItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FuelReportItem) {
            throw new \InvalidArgumentException(sprintf('The FuelReportItem property can only contain items of \StructType\FuelReportItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FuelReportItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FuelReportItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FuelReportItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FuelReportItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FuelReportItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FuelReportItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FuelReportItem
     */
    public function getAttributeName()
    {
        return 'FuelReportItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFuelReportItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
