<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFileResultItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfFileResultItem extends AbstractStructArrayBase
{
    /**
     * The FileResultItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FileResultItem[]
     */
    public $FileResultItem;
    /**
     * Constructor method for ArrayOfFileResultItem
     * @uses ArrayOfFileResultItem::setFileResultItem()
     * @param \StructType\FileResultItem[] $fileResultItem
     */
    public function __construct(array $fileResultItem = array())
    {
        $this
            ->setFileResultItem($fileResultItem);
    }
    /**
     * Get FileResultItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FileResultItem[]|null
     */
    public function getFileResultItem()
    {
        return isset($this->FileResultItem) ? $this->FileResultItem : null;
    }
    /**
     * Set FileResultItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FileResultItem[] $fileResultItem
     * @return \ArrayType\ArrayOfFileResultItem
     */
    public function setFileResultItem(array $fileResultItem = array())
    {
        foreach ($fileResultItem as $arrayOfFileResultItemFileResultItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfFileResultItemFileResultItemItem instanceof \StructType\FileResultItem) {
                throw new \InvalidArgumentException(sprintf('The FileResultItem property can only contain items of \StructType\FileResultItem, "%s" given', is_object($arrayOfFileResultItemFileResultItemItem) ? get_class($arrayOfFileResultItemFileResultItemItem) : gettype($arrayOfFileResultItemFileResultItemItem)), __LINE__);
            }
        }
        if (is_null($fileResultItem) || (is_array($fileResultItem) && empty($fileResultItem))) {
            unset($this->FileResultItem);
        } else {
            $this->FileResultItem = $fileResultItem;
        }
        return $this;
    }
    /**
     * Add item to FileResultItem value
     * @throws \InvalidArgumentException
     * @param \StructType\FileResultItem $item
     * @return \ArrayType\ArrayOfFileResultItem
     */
    public function addToFileResultItem(\StructType\FileResultItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FileResultItem) {
            throw new \InvalidArgumentException(sprintf('The FileResultItem property can only contain items of \StructType\FileResultItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FileResultItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FileResultItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FileResultItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FileResultItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FileResultItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FileResultItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FileResultItem
     */
    public function getAttributeName()
    {
        return 'FileResultItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFileResultItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
