<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExtraInfo_V3 ArrayType
 * @subpackage Arrays
 */
class ArrayOfExtraInfo_V3 extends AbstractStructArrayBase
{
    /**
     * The ExtraInfo_V3
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExtraInfo_V3[]
     */
    public $ExtraInfo_V3;
    /**
     * Constructor method for ArrayOfExtraInfo_V3
     * @uses ArrayOfExtraInfo_V3::setExtraInfo_V3()
     * @param \StructType\ExtraInfo_V3[] $extraInfo_V3
     */
    public function __construct(array $extraInfo_V3 = array())
    {
        $this
            ->setExtraInfo_V3($extraInfo_V3);
    }
    /**
     * Get ExtraInfo_V3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExtraInfo_V3[]|null
     */
    public function getExtraInfo_V3()
    {
        return isset($this->ExtraInfo_V3) ? $this->ExtraInfo_V3 : null;
    }
    /**
     * Set ExtraInfo_V3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo_V3[] $extraInfo_V3
     * @return \ArrayType\ArrayOfExtraInfo_V3
     */
    public function setExtraInfo_V3(array $extraInfo_V3 = array())
    {
        foreach ($extraInfo_V3 as $arrayOfExtraInfo_V3ExtraInfo_V3Item) {
            // validation for constraint: itemType
            if (!$arrayOfExtraInfo_V3ExtraInfo_V3Item instanceof \StructType\ExtraInfo_V3) {
                throw new \InvalidArgumentException(sprintf('The ExtraInfo_V3 property can only contain items of \StructType\ExtraInfo_V3, "%s" given', is_object($arrayOfExtraInfo_V3ExtraInfo_V3Item) ? get_class($arrayOfExtraInfo_V3ExtraInfo_V3Item) : gettype($arrayOfExtraInfo_V3ExtraInfo_V3Item)), __LINE__);
            }
        }
        if (is_null($extraInfo_V3) || (is_array($extraInfo_V3) && empty($extraInfo_V3))) {
            unset($this->ExtraInfo_V3);
        } else {
            $this->ExtraInfo_V3 = $extraInfo_V3;
        }
        return $this;
    }
    /**
     * Add item to ExtraInfo_V3 value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo_V3 $item
     * @return \ArrayType\ArrayOfExtraInfo_V3
     */
    public function addToExtraInfo_V3(\StructType\ExtraInfo_V3 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtraInfo_V3) {
            throw new \InvalidArgumentException(sprintf('The ExtraInfo_V3 property can only contain items of \StructType\ExtraInfo_V3, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtraInfo_V3[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ExtraInfo_V3|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ExtraInfo_V3|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ExtraInfo_V3|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ExtraInfo_V3|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ExtraInfo_V3|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExtraInfo_V3
     */
    public function getAttributeName()
    {
        return 'ExtraInfo_V3';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfExtraInfo_V3
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
