<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfExtraInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfExtraInfo extends AbstractStructArrayBase
{
    /**
     * The ExtraInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExtraInfo[]
     */
    public $ExtraInfo;
    /**
     * Constructor method for ArrayOfExtraInfo
     * @uses ArrayOfExtraInfo::setExtraInfo()
     * @param \StructType\ExtraInfo[] $extraInfo
     */
    public function __construct(array $extraInfo = array())
    {
        $this
            ->setExtraInfo($extraInfo);
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExtraInfo[]|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo[] $extraInfo
     * @return \ArrayType\ArrayOfExtraInfo
     */
    public function setExtraInfo(array $extraInfo = array())
    {
        foreach ($extraInfo as $arrayOfExtraInfoExtraInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfExtraInfoExtraInfoItem instanceof \StructType\ExtraInfo) {
                throw new \InvalidArgumentException(sprintf('The ExtraInfo property can only contain items of \StructType\ExtraInfo, "%s" given', is_object($arrayOfExtraInfoExtraInfoItem) ? get_class($arrayOfExtraInfoExtraInfoItem) : gettype($arrayOfExtraInfoExtraInfoItem)), __LINE__);
            }
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Add item to ExtraInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraInfo $item
     * @return \ArrayType\ArrayOfExtraInfo
     */
    public function addToExtraInfo(\StructType\ExtraInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtraInfo) {
            throw new \InvalidArgumentException(sprintf('The ExtraInfo property can only contain items of \StructType\ExtraInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtraInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ExtraInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ExtraInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ExtraInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ExtraInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ExtraInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ExtraInfo
     */
    public function getAttributeName()
    {
        return 'ExtraInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfExtraInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
