<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDocument_V6 ArrayType
 * @subpackage Arrays
 */
class ArrayOfDocument_V6 extends AbstractStructArrayBase
{
    /**
     * The Document_V6
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Document_V6[]
     */
    public $Document_V6;
    /**
     * Constructor method for ArrayOfDocument_V6
     * @uses ArrayOfDocument_V6::setDocument_V6()
     * @param \StructType\Document_V6[] $document_V6
     */
    public function __construct(array $document_V6 = array())
    {
        $this
            ->setDocument_V6($document_V6);
    }
    /**
     * Get Document_V6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Document_V6[]|null
     */
    public function getDocument_V6()
    {
        return isset($this->Document_V6) ? $this->Document_V6 : null;
    }
    /**
     * Set Document_V6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Document_V6[] $document_V6
     * @return \ArrayType\ArrayOfDocument_V6
     */
    public function setDocument_V6(array $document_V6 = array())
    {
        foreach ($document_V6 as $arrayOfDocument_V6Document_V6Item) {
            // validation for constraint: itemType
            if (!$arrayOfDocument_V6Document_V6Item instanceof \StructType\Document_V6) {
                throw new \InvalidArgumentException(sprintf('The Document_V6 property can only contain items of \StructType\Document_V6, "%s" given', is_object($arrayOfDocument_V6Document_V6Item) ? get_class($arrayOfDocument_V6Document_V6Item) : gettype($arrayOfDocument_V6Document_V6Item)), __LINE__);
            }
        }
        if (is_null($document_V6) || (is_array($document_V6) && empty($document_V6))) {
            unset($this->Document_V6);
        } else {
            $this->Document_V6 = $document_V6;
        }
        return $this;
    }
    /**
     * Add item to Document_V6 value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_V6 $item
     * @return \ArrayType\ArrayOfDocument_V6
     */
    public function addToDocument_V6(\StructType\Document_V6 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_V6) {
            throw new \InvalidArgumentException(sprintf('The Document_V6 property can only contain items of \StructType\Document_V6, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document_V6[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Document_V6|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Document_V6|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Document_V6|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Document_V6|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Document_V6|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Document_V6
     */
    public function getAttributeName()
    {
        return 'Document_V6';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDocument_V6
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
