<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfConsultation ArrayType
 * @subpackage Arrays
 */
class ArrayOfConsultation extends AbstractStructArrayBase
{
    /**
     * The Consultation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Consultation[]
     */
    public $Consultation;
    /**
     * Constructor method for ArrayOfConsultation
     * @uses ArrayOfConsultation::setConsultation()
     * @param \StructType\Consultation[] $consultation
     */
    public function __construct(array $consultation = array())
    {
        $this
            ->setConsultation($consultation);
    }
    /**
     * Get Consultation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Consultation[]|null
     */
    public function getConsultation()
    {
        return isset($this->Consultation) ? $this->Consultation : null;
    }
    /**
     * Set Consultation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Consultation[] $consultation
     * @return \ArrayType\ArrayOfConsultation
     */
    public function setConsultation(array $consultation = array())
    {
        foreach ($consultation as $arrayOfConsultationConsultationItem) {
            // validation for constraint: itemType
            if (!$arrayOfConsultationConsultationItem instanceof \StructType\Consultation) {
                throw new \InvalidArgumentException(sprintf('The Consultation property can only contain items of \StructType\Consultation, "%s" given', is_object($arrayOfConsultationConsultationItem) ? get_class($arrayOfConsultationConsultationItem) : gettype($arrayOfConsultationConsultationItem)), __LINE__);
            }
        }
        if (is_null($consultation) || (is_array($consultation) && empty($consultation))) {
            unset($this->Consultation);
        } else {
            $this->Consultation = $consultation;
        }
        return $this;
    }
    /**
     * Add item to Consultation value
     * @throws \InvalidArgumentException
     * @param \StructType\Consultation $item
     * @return \ArrayType\ArrayOfConsultation
     */
    public function addToConsultation(\StructType\Consultation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Consultation) {
            throw new \InvalidArgumentException(sprintf('The Consultation property can only contain items of \StructType\Consultation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Consultation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Consultation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Consultation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Consultation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Consultation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Consultation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Consultation
     */
    public function getAttributeName()
    {
        return 'Consultation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfConsultation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
