<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCodeInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfCodeInfo extends AbstractStructArrayBase
{
    /**
     * The CodeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CodeInfo[]
     */
    public $CodeInfo;
    /**
     * Constructor method for ArrayOfCodeInfo
     * @uses ArrayOfCodeInfo::setCodeInfo()
     * @param \StructType\CodeInfo[] $codeInfo
     */
    public function __construct(array $codeInfo = array())
    {
        $this
            ->setCodeInfo($codeInfo);
    }
    /**
     * Get CodeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CodeInfo[]|null
     */
    public function getCodeInfo()
    {
        return isset($this->CodeInfo) ? $this->CodeInfo : null;
    }
    /**
     * Set CodeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CodeInfo[] $codeInfo
     * @return \ArrayType\ArrayOfCodeInfo
     */
    public function setCodeInfo(array $codeInfo = array())
    {
        foreach ($codeInfo as $arrayOfCodeInfoCodeInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCodeInfoCodeInfoItem instanceof \StructType\CodeInfo) {
                throw new \InvalidArgumentException(sprintf('The CodeInfo property can only contain items of \StructType\CodeInfo, "%s" given', is_object($arrayOfCodeInfoCodeInfoItem) ? get_class($arrayOfCodeInfoCodeInfoItem) : gettype($arrayOfCodeInfoCodeInfoItem)), __LINE__);
            }
        }
        if (is_null($codeInfo) || (is_array($codeInfo) && empty($codeInfo))) {
            unset($this->CodeInfo);
        } else {
            $this->CodeInfo = $codeInfo;
        }
        return $this;
    }
    /**
     * Add item to CodeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CodeInfo $item
     * @return \ArrayType\ArrayOfCodeInfo
     */
    public function addToCodeInfo(\StructType\CodeInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CodeInfo) {
            throw new \InvalidArgumentException(sprintf('The CodeInfo property can only contain items of \StructType\CodeInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CodeInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CodeInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CodeInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CodeInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CodeInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CodeInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CodeInfo
     */
    public function getAttributeName()
    {
        return 'CodeInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCodeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
