<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCode ArrayType
 * @subpackage Arrays
 */
class ArrayOfCode extends AbstractStructArrayBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Code[]
     */
    public $Code;
    /**
     * Constructor method for ArrayOfCode
     * @uses ArrayOfCode::setCode()
     * @param \StructType\Code[] $code
     */
    public function __construct(array $code = array())
    {
        $this
            ->setCode($code);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Code[]|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Code[] $code
     * @return \ArrayType\ArrayOfCode
     */
    public function setCode(array $code = array())
    {
        foreach ($code as $arrayOfCodeCodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfCodeCodeItem instanceof \StructType\Code) {
                throw new \InvalidArgumentException(sprintf('The Code property can only contain items of \StructType\Code, "%s" given', is_object($arrayOfCodeCodeItem) ? get_class($arrayOfCodeCodeItem) : gettype($arrayOfCodeCodeItem)), __LINE__);
            }
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Add item to Code value
     * @throws \InvalidArgumentException
     * @param \StructType\Code $item
     * @return \ArrayType\ArrayOfCode
     */
    public function addToCode(\StructType\Code $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code) {
            throw new \InvalidArgumentException(sprintf('The Code property can only contain items of \StructType\Code, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Code[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Code|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Code|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Code|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Code|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Code|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Code
     */
    public function getAttributeName()
    {
        return 'Code';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
