<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClassItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfClassItem extends AbstractStructArrayBase
{
    /**
     * The ClassItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClassItem[]
     */
    public $ClassItem;
    /**
     * Constructor method for ArrayOfClassItem
     * @uses ArrayOfClassItem::setClassItem()
     * @param \StructType\ClassItem[] $classItem
     */
    public function __construct(array $classItem = array())
    {
        $this
            ->setClassItem($classItem);
    }
    /**
     * Get ClassItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClassItem[]|null
     */
    public function getClassItem()
    {
        return isset($this->ClassItem) ? $this->ClassItem : null;
    }
    /**
     * Set ClassItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClassItem[] $classItem
     * @return \ArrayType\ArrayOfClassItem
     */
    public function setClassItem(array $classItem = array())
    {
        foreach ($classItem as $arrayOfClassItemClassItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfClassItemClassItemItem instanceof \StructType\ClassItem) {
                throw new \InvalidArgumentException(sprintf('The ClassItem property can only contain items of \StructType\ClassItem, "%s" given', is_object($arrayOfClassItemClassItemItem) ? get_class($arrayOfClassItemClassItemItem) : gettype($arrayOfClassItemClassItemItem)), __LINE__);
            }
        }
        if (is_null($classItem) || (is_array($classItem) && empty($classItem))) {
            unset($this->ClassItem);
        } else {
            $this->ClassItem = $classItem;
        }
        return $this;
    }
    /**
     * Add item to ClassItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ClassItem $item
     * @return \ArrayType\ArrayOfClassItem
     */
    public function addToClassItem(\StructType\ClassItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClassItem) {
            throw new \InvalidArgumentException(sprintf('The ClassItem property can only contain items of \StructType\ClassItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClassItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClassItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClassItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClassItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClassItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClassItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClassItem
     */
    public function getAttributeName()
    {
        return 'ClassItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfClassItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
