<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAssetSubGroupItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfAssetSubGroupItem extends AbstractStructArrayBase
{
    /**
     * The AssetSubGroupItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssetSubGroupItem[]
     */
    public $AssetSubGroupItem;
    /**
     * Constructor method for ArrayOfAssetSubGroupItem
     * @uses ArrayOfAssetSubGroupItem::setAssetSubGroupItem()
     * @param \StructType\AssetSubGroupItem[] $assetSubGroupItem
     */
    public function __construct(array $assetSubGroupItem = array())
    {
        $this
            ->setAssetSubGroupItem($assetSubGroupItem);
    }
    /**
     * Get AssetSubGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssetSubGroupItem[]|null
     */
    public function getAssetSubGroupItem()
    {
        return isset($this->AssetSubGroupItem) ? $this->AssetSubGroupItem : null;
    }
    /**
     * Set AssetSubGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AssetSubGroupItem[] $assetSubGroupItem
     * @return \ArrayType\ArrayOfAssetSubGroupItem
     */
    public function setAssetSubGroupItem(array $assetSubGroupItem = array())
    {
        foreach ($assetSubGroupItem as $arrayOfAssetSubGroupItemAssetSubGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfAssetSubGroupItemAssetSubGroupItemItem instanceof \StructType\AssetSubGroupItem) {
                throw new \InvalidArgumentException(sprintf('The AssetSubGroupItem property can only contain items of \StructType\AssetSubGroupItem, "%s" given', is_object($arrayOfAssetSubGroupItemAssetSubGroupItemItem) ? get_class($arrayOfAssetSubGroupItemAssetSubGroupItemItem) : gettype($arrayOfAssetSubGroupItemAssetSubGroupItemItem)), __LINE__);
            }
        }
        if (is_null($assetSubGroupItem) || (is_array($assetSubGroupItem) && empty($assetSubGroupItem))) {
            unset($this->AssetSubGroupItem);
        } else {
            $this->AssetSubGroupItem = $assetSubGroupItem;
        }
        return $this;
    }
    /**
     * Add item to AssetSubGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\AssetSubGroupItem $item
     * @return \ArrayType\ArrayOfAssetSubGroupItem
     */
    public function addToAssetSubGroupItem(\StructType\AssetSubGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssetSubGroupItem) {
            throw new \InvalidArgumentException(sprintf('The AssetSubGroupItem property can only contain items of \StructType\AssetSubGroupItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AssetSubGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AssetSubGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AssetSubGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AssetSubGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AssetSubGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AssetSubGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AssetSubGroupItem
     */
    public function getAttributeName()
    {
        return 'AssetSubGroupItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAssetSubGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
