<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdditionalRecipient ArrayType
 * @subpackage Arrays
 */
class ArrayOfAdditionalRecipient extends AbstractStructArrayBase
{
    /**
     * The AdditionalRecipient
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalRecipient[]
     */
    public $AdditionalRecipient;
    /**
     * Constructor method for ArrayOfAdditionalRecipient
     * @uses ArrayOfAdditionalRecipient::setAdditionalRecipient()
     * @param \StructType\AdditionalRecipient[] $additionalRecipient
     */
    public function __construct(array $additionalRecipient = array())
    {
        $this
            ->setAdditionalRecipient($additionalRecipient);
    }
    /**
     * Get AdditionalRecipient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalRecipient[]|null
     */
    public function getAdditionalRecipient()
    {
        return isset($this->AdditionalRecipient) ? $this->AdditionalRecipient : null;
    }
    /**
     * Set AdditionalRecipient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalRecipient[] $additionalRecipient
     * @return \ArrayType\ArrayOfAdditionalRecipient
     */
    public function setAdditionalRecipient(array $additionalRecipient = array())
    {
        foreach ($additionalRecipient as $arrayOfAdditionalRecipientAdditionalRecipientItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdditionalRecipientAdditionalRecipientItem instanceof \StructType\AdditionalRecipient) {
                throw new \InvalidArgumentException(sprintf('The AdditionalRecipient property can only contain items of \StructType\AdditionalRecipient, "%s" given', is_object($arrayOfAdditionalRecipientAdditionalRecipientItem) ? get_class($arrayOfAdditionalRecipientAdditionalRecipientItem) : gettype($arrayOfAdditionalRecipientAdditionalRecipientItem)), __LINE__);
            }
        }
        if (is_null($additionalRecipient) || (is_array($additionalRecipient) && empty($additionalRecipient))) {
            unset($this->AdditionalRecipient);
        } else {
            $this->AdditionalRecipient = $additionalRecipient;
        }
        return $this;
    }
    /**
     * Add item to AdditionalRecipient value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalRecipient $item
     * @return \ArrayType\ArrayOfAdditionalRecipient
     */
    public function addToAdditionalRecipient(\StructType\AdditionalRecipient $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalRecipient) {
            throw new \InvalidArgumentException(sprintf('The AdditionalRecipient property can only contain items of \StructType\AdditionalRecipient, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalRecipient[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AdditionalRecipient|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AdditionalRecipient|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AdditionalRecipient|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AdditionalRecipient|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AdditionalRecipient|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalRecipient
     */
    public function getAttributeName()
    {
        return 'AdditionalRecipient';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAdditionalRecipient
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
