<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityReportItem_V7 ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityReportItem_V7 extends AbstractStructArrayBase
{
    /**
     * The ActivityReportItem_V7
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityReportItem_V7[]
     */
    public $ActivityReportItem_V7;
    /**
     * Constructor method for ArrayOfActivityReportItem_V7
     * @uses ArrayOfActivityReportItem_V7::setActivityReportItem_V7()
     * @param \StructType\ActivityReportItem_V7[] $activityReportItem_V7
     */
    public function __construct(array $activityReportItem_V7 = array())
    {
        $this
            ->setActivityReportItem_V7($activityReportItem_V7);
    }
    /**
     * Get ActivityReportItem_V7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityReportItem_V7[]|null
     */
    public function getActivityReportItem_V7()
    {
        return isset($this->ActivityReportItem_V7) ? $this->ActivityReportItem_V7 : null;
    }
    /**
     * Set ActivityReportItem_V7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem_V7[] $activityReportItem_V7
     * @return \ArrayType\ArrayOfActivityReportItem_V7
     */
    public function setActivityReportItem_V7(array $activityReportItem_V7 = array())
    {
        foreach ($activityReportItem_V7 as $arrayOfActivityReportItem_V7ActivityReportItem_V7Item) {
            // validation for constraint: itemType
            if (!$arrayOfActivityReportItem_V7ActivityReportItem_V7Item instanceof \StructType\ActivityReportItem_V7) {
                throw new \InvalidArgumentException(sprintf('The ActivityReportItem_V7 property can only contain items of \StructType\ActivityReportItem_V7, "%s" given', is_object($arrayOfActivityReportItem_V7ActivityReportItem_V7Item) ? get_class($arrayOfActivityReportItem_V7ActivityReportItem_V7Item) : gettype($arrayOfActivityReportItem_V7ActivityReportItem_V7Item)), __LINE__);
            }
        }
        if (is_null($activityReportItem_V7) || (is_array($activityReportItem_V7) && empty($activityReportItem_V7))) {
            unset($this->ActivityReportItem_V7);
        } else {
            $this->ActivityReportItem_V7 = $activityReportItem_V7;
        }
        return $this;
    }
    /**
     * Add item to ActivityReportItem_V7 value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportItem_V7 $item
     * @return \ArrayType\ArrayOfActivityReportItem_V7
     */
    public function addToActivityReportItem_V7(\StructType\ActivityReportItem_V7 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityReportItem_V7) {
            throw new \InvalidArgumentException(sprintf('The ActivityReportItem_V7 property can only contain items of \StructType\ActivityReportItem_V7, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityReportItem_V7[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityReportItem_V7|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityReportItem_V7|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityReportItem_V7|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityReportItem_V7|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityReportItem_V7|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityReportItem_V7
     */
    public function getAttributeName()
    {
        return 'ActivityReportItem_V7';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfActivityReportItem_V7
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
