<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityReportDetailItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityReportDetailItem extends AbstractStructArrayBase
{
    /**
     * The ActivityReportDetailItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityReportDetailItem[]
     */
    public $ActivityReportDetailItem;
    /**
     * Constructor method for ArrayOfActivityReportDetailItem
     * @uses ArrayOfActivityReportDetailItem::setActivityReportDetailItem()
     * @param \StructType\ActivityReportDetailItem[] $activityReportDetailItem
     */
    public function __construct(array $activityReportDetailItem = array())
    {
        $this
            ->setActivityReportDetailItem($activityReportDetailItem);
    }
    /**
     * Get ActivityReportDetailItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityReportDetailItem[]|null
     */
    public function getActivityReportDetailItem()
    {
        return isset($this->ActivityReportDetailItem) ? $this->ActivityReportDetailItem : null;
    }
    /**
     * Set ActivityReportDetailItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportDetailItem[] $activityReportDetailItem
     * @return \ArrayType\ArrayOfActivityReportDetailItem
     */
    public function setActivityReportDetailItem(array $activityReportDetailItem = array())
    {
        foreach ($activityReportDetailItem as $arrayOfActivityReportDetailItemActivityReportDetailItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityReportDetailItemActivityReportDetailItemItem instanceof \StructType\ActivityReportDetailItem) {
                throw new \InvalidArgumentException(sprintf('The ActivityReportDetailItem property can only contain items of \StructType\ActivityReportDetailItem, "%s" given', is_object($arrayOfActivityReportDetailItemActivityReportDetailItemItem) ? get_class($arrayOfActivityReportDetailItemActivityReportDetailItemItem) : gettype($arrayOfActivityReportDetailItemActivityReportDetailItemItem)), __LINE__);
            }
        }
        if (is_null($activityReportDetailItem) || (is_array($activityReportDetailItem) && empty($activityReportDetailItem))) {
            unset($this->ActivityReportDetailItem);
        } else {
            $this->ActivityReportDetailItem = $activityReportDetailItem;
        }
        return $this;
    }
    /**
     * Add item to ActivityReportDetailItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityReportDetailItem $item
     * @return \ArrayType\ArrayOfActivityReportDetailItem
     */
    public function addToActivityReportDetailItem(\StructType\ActivityReportDetailItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityReportDetailItem) {
            throw new \InvalidArgumentException(sprintf('The ActivityReportDetailItem property can only contain items of \StructType\ActivityReportDetailItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityReportDetailItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityReportDetailItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityReportDetailItem
     */
    public function getAttributeName()
    {
        return 'ActivityReportDetailItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfActivityReportDetailItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
