<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivityRemarkItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivityRemarkItem extends AbstractStructArrayBase
{
    /**
     * The ActivityRemarkItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ActivityRemarkItem[]
     */
    public $ActivityRemarkItem;
    /**
     * Constructor method for ArrayOfActivityRemarkItem
     * @uses ArrayOfActivityRemarkItem::setActivityRemarkItem()
     * @param \StructType\ActivityRemarkItem[] $activityRemarkItem
     */
    public function __construct(array $activityRemarkItem = array())
    {
        $this
            ->setActivityRemarkItem($activityRemarkItem);
    }
    /**
     * Get ActivityRemarkItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ActivityRemarkItem[]|null
     */
    public function getActivityRemarkItem()
    {
        return isset($this->ActivityRemarkItem) ? $this->ActivityRemarkItem : null;
    }
    /**
     * Set ActivityRemarkItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRemarkItem[] $activityRemarkItem
     * @return \ArrayType\ArrayOfActivityRemarkItem
     */
    public function setActivityRemarkItem(array $activityRemarkItem = array())
    {
        foreach ($activityRemarkItem as $arrayOfActivityRemarkItemActivityRemarkItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfActivityRemarkItemActivityRemarkItemItem instanceof \StructType\ActivityRemarkItem) {
                throw new \InvalidArgumentException(sprintf('The ActivityRemarkItem property can only contain items of \StructType\ActivityRemarkItem, "%s" given', is_object($arrayOfActivityRemarkItemActivityRemarkItemItem) ? get_class($arrayOfActivityRemarkItemActivityRemarkItemItem) : gettype($arrayOfActivityRemarkItemActivityRemarkItemItem)), __LINE__);
            }
        }
        if (is_null($activityRemarkItem) || (is_array($activityRemarkItem) && empty($activityRemarkItem))) {
            unset($this->ActivityRemarkItem);
        } else {
            $this->ActivityRemarkItem = $activityRemarkItem;
        }
        return $this;
    }
    /**
     * Add item to ActivityRemarkItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityRemarkItem $item
     * @return \ArrayType\ArrayOfActivityRemarkItem
     */
    public function addToActivityRemarkItem(\StructType\ActivityRemarkItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityRemarkItem) {
            throw new \InvalidArgumentException(sprintf('The ActivityRemarkItem property can only contain items of \StructType\ActivityRemarkItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityRemarkItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ActivityRemarkItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ActivityRemarkItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ActivityRemarkItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ActivityRemarkItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ActivityRemarkItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ActivityRemarkItem
     */
    public function getAttributeName()
    {
        return 'ActivityRemarkItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfActivityRemarkItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
