<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaRouteTransferResult StructType
 * @subpackage Structs
 */
class ViaRouteTransferResult extends AbstractStructBase
{
    /**
     * The TransferStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TransferStatus;
    /**
     * The DeleteStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeleteStatus;
    /**
     * The DeleteReason
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DeleteReason;
    /**
     * The Send
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Send;
    /**
     * The Delivered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Delivered;
    /**
     * The Deleted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Deleted;
    /**
     * The Created
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Created;
    /**
     * The Modified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Modified;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierVehicleResult
     */
    public $Vehicle;
    /**
     * The Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Dispatcher;
    /**
     * The Deleted_by_Driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Deleted_by_Driver;
    /**
     * The Deleted_by_Dispatcher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IdentifierPerson
     */
    public $Deleted_by_Dispatcher;
    /**
     * Constructor method for ViaRouteTransferResult
     * @uses ViaRouteTransferResult::setTransferStatus()
     * @uses ViaRouteTransferResult::setDeleteStatus()
     * @uses ViaRouteTransferResult::setDeleteReason()
     * @uses ViaRouteTransferResult::setSend()
     * @uses ViaRouteTransferResult::setDelivered()
     * @uses ViaRouteTransferResult::setDeleted()
     * @uses ViaRouteTransferResult::setCreated()
     * @uses ViaRouteTransferResult::setModified()
     * @uses ViaRouteTransferResult::setVehicle()
     * @uses ViaRouteTransferResult::setDispatcher()
     * @uses ViaRouteTransferResult::setDeleted_by_Driver()
     * @uses ViaRouteTransferResult::setDeleted_by_Dispatcher()
     * @param string $transferStatus
     * @param string $deleteStatus
     * @param string $deleteReason
     * @param string $send
     * @param string $delivered
     * @param string $deleted
     * @param string $created
     * @param string $modified
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @param \StructType\IdentifierPerson $dispatcher
     * @param \StructType\IdentifierPerson $deleted_by_Driver
     * @param \StructType\IdentifierPerson $deleted_by_Dispatcher
     */
    public function __construct($transferStatus = null, $deleteStatus = null, $deleteReason = null, $send = null, $delivered = null, $deleted = null, $created = null, $modified = null, \StructType\IdentifierVehicleResult $vehicle = null, \StructType\IdentifierPerson $dispatcher = null, \StructType\IdentifierPerson $deleted_by_Driver = null, \StructType\IdentifierPerson $deleted_by_Dispatcher = null)
    {
        $this
            ->setTransferStatus($transferStatus)
            ->setDeleteStatus($deleteStatus)
            ->setDeleteReason($deleteReason)
            ->setSend($send)
            ->setDelivered($delivered)
            ->setDeleted($deleted)
            ->setCreated($created)
            ->setModified($modified)
            ->setVehicle($vehicle)
            ->setDispatcher($dispatcher)
            ->setDeleted_by_Driver($deleted_by_Driver)
            ->setDeleted_by_Dispatcher($deleted_by_Dispatcher);
    }
    /**
     * Get TransferStatus value
     * @return string
     */
    public function getTransferStatus()
    {
        return $this->TransferStatus;
    }
    /**
     * Set TransferStatus value
     * @uses \EnumType\EnumViaRouteTransferStatus::valueIsValid()
     * @uses \EnumType\EnumViaRouteTransferStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferStatus
     * @return \StructType\ViaRouteTransferResult
     */
    public function setTransferStatus($transferStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteTransferStatus::valueIsValid($transferStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transferStatus, implode(', ', \EnumType\EnumViaRouteTransferStatus::getValidValues())), __LINE__);
        }
        $this->TransferStatus = $transferStatus;
        return $this;
    }
    /**
     * Get DeleteStatus value
     * @return string
     */
    public function getDeleteStatus()
    {
        return $this->DeleteStatus;
    }
    /**
     * Set DeleteStatus value
     * @uses \EnumType\EnumViaRouteDeleteStatus::valueIsValid()
     * @uses \EnumType\EnumViaRouteDeleteStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteStatus
     * @return \StructType\ViaRouteTransferResult
     */
    public function setDeleteStatus($deleteStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteDeleteStatus::valueIsValid($deleteStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteStatus, implode(', ', \EnumType\EnumViaRouteDeleteStatus::getValidValues())), __LINE__);
        }
        $this->DeleteStatus = $deleteStatus;
        return $this;
    }
    /**
     * Get DeleteReason value
     * @return string
     */
    public function getDeleteReason()
    {
        return $this->DeleteReason;
    }
    /**
     * Set DeleteReason value
     * @uses \EnumType\EnumViaRouteDeleteReason::valueIsValid()
     * @uses \EnumType\EnumViaRouteDeleteReason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteReason
     * @return \StructType\ViaRouteTransferResult
     */
    public function setDeleteReason($deleteReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteDeleteReason::valueIsValid($deleteReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteReason, implode(', ', \EnumType\EnumViaRouteDeleteReason::getValidValues())), __LINE__);
        }
        $this->DeleteReason = $deleteReason;
        return $this;
    }
    /**
     * Get Send value
     * @return string
     */
    public function getSend()
    {
        return $this->Send;
    }
    /**
     * Set Send value
     * @param string $send
     * @return \StructType\ViaRouteTransferResult
     */
    public function setSend($send = null)
    {
        // validation for constraint: string
        if (!is_null($send) && !is_string($send)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($send)), __LINE__);
        }
        $this->Send = $send;
        return $this;
    }
    /**
     * Get Delivered value
     * @return string
     */
    public function getDelivered()
    {
        return $this->Delivered;
    }
    /**
     * Set Delivered value
     * @param string $delivered
     * @return \StructType\ViaRouteTransferResult
     */
    public function setDelivered($delivered = null)
    {
        // validation for constraint: string
        if (!is_null($delivered) && !is_string($delivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delivered)), __LINE__);
        }
        $this->Delivered = $delivered;
        return $this;
    }
    /**
     * Get Deleted value
     * @return string
     */
    public function getDeleted()
    {
        return $this->Deleted;
    }
    /**
     * Set Deleted value
     * @param string $deleted
     * @return \StructType\ViaRouteTransferResult
     */
    public function setDeleted($deleted = null)
    {
        // validation for constraint: string
        if (!is_null($deleted) && !is_string($deleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deleted)), __LINE__);
        }
        $this->Deleted = $deleted;
        return $this;
    }
    /**
     * Get Created value
     * @return string
     */
    public function getCreated()
    {
        return $this->Created;
    }
    /**
     * Set Created value
     * @param string $created
     * @return \StructType\ViaRouteTransferResult
     */
    public function setCreated($created = null)
    {
        // validation for constraint: string
        if (!is_null($created) && !is_string($created)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($created)), __LINE__);
        }
        $this->Created = $created;
        return $this;
    }
    /**
     * Get Modified value
     * @return string
     */
    public function getModified()
    {
        return $this->Modified;
    }
    /**
     * Set Modified value
     * @param string $modified
     * @return \StructType\ViaRouteTransferResult
     */
    public function setModified($modified = null)
    {
        // validation for constraint: string
        if (!is_null($modified) && !is_string($modified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modified)), __LINE__);
        }
        $this->Modified = $modified;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \StructType\IdentifierVehicleResult|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \StructType\IdentifierVehicleResult $vehicle
     * @return \StructType\ViaRouteTransferResult
     */
    public function setVehicle(\StructType\IdentifierVehicleResult $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Dispatcher value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDispatcher()
    {
        return $this->Dispatcher;
    }
    /**
     * Set Dispatcher value
     * @param \StructType\IdentifierPerson $dispatcher
     * @return \StructType\ViaRouteTransferResult
     */
    public function setDispatcher(\StructType\IdentifierPerson $dispatcher = null)
    {
        $this->Dispatcher = $dispatcher;
        return $this;
    }
    /**
     * Get Deleted_by_Driver value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDeleted_by_Driver()
    {
        return $this->Deleted_by_Driver;
    }
    /**
     * Set Deleted_by_Driver value
     * @param \StructType\IdentifierPerson $deleted_by_Driver
     * @return \StructType\ViaRouteTransferResult
     */
    public function setDeleted_by_Driver(\StructType\IdentifierPerson $deleted_by_Driver = null)
    {
        $this->Deleted_by_Driver = $deleted_by_Driver;
        return $this;
    }
    /**
     * Get Deleted_by_Dispatcher value
     * @return \StructType\IdentifierPerson|null
     */
    public function getDeleted_by_Dispatcher()
    {
        return $this->Deleted_by_Dispatcher;
    }
    /**
     * Set Deleted_by_Dispatcher value
     * @param \StructType\IdentifierPerson $deleted_by_Dispatcher
     * @return \StructType\ViaRouteTransferResult
     */
    public function setDeleted_by_Dispatcher(\StructType\IdentifierPerson $deleted_by_Dispatcher = null)
    {
        $this->Deleted_by_Dispatcher = $deleted_by_Dispatcher;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ViaRouteTransferResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
