<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaRouteInsertGPX StructType
 * @subpackage Structs
 */
class ViaRouteInsertGPX extends ViaRoute_WithBehavior
{
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Radius;
    /**
     * The gpx
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gpx;
    /**
     * Constructor method for ViaRouteInsertGPX
     * @uses ViaRouteInsertGPX::setRadius()
     * @uses ViaRouteInsertGPX::setGpx()
     * @param int $radius
     * @param string $gpx
     */
    public function __construct($radius = null, $gpx = null)
    {
        $this
            ->setRadius($radius)
            ->setGpx($gpx);
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \StructType\ViaRouteInsertGPX
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get gpx value
     * @return string|null
     */
    public function getGpx()
    {
        return $this->gpx;
    }
    /**
     * Set gpx value
     * @param string $gpx
     * @return \StructType\ViaRouteInsertGPX
     */
    public function setGpx($gpx = null)
    {
        // validation for constraint: string
        if (!is_null($gpx) && !is_string($gpx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gpx)), __LINE__);
        }
        $this->gpx = $gpx;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ViaRouteInsertGPX
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
