<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViaRoute StructType
 * @subpackage Structs
 */
class ViaRoute extends AbstractStructBase
{
    /**
     * The Secure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Secure;
    /**
     * The ViaRouteType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ViaRouteType;
    /**
     * The ViaRoutePlanningType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ViaRoutePlanningType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for ViaRoute
     * @uses ViaRoute::setSecure()
     * @uses ViaRoute::setViaRouteType()
     * @uses ViaRoute::setViaRoutePlanningType()
     * @uses ViaRoute::setName()
     * @uses ViaRoute::setDescription()
     * @param bool $secure
     * @param string $viaRouteType
     * @param string $viaRoutePlanningType
     * @param string $name
     * @param string $description
     */
    public function __construct($secure = null, $viaRouteType = null, $viaRoutePlanningType = null, $name = null, $description = null)
    {
        $this
            ->setSecure($secure)
            ->setViaRouteType($viaRouteType)
            ->setViaRoutePlanningType($viaRoutePlanningType)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get Secure value
     * @return bool
     */
    public function getSecure()
    {
        return $this->Secure;
    }
    /**
     * Set Secure value
     * @param bool $secure
     * @return \StructType\ViaRoute
     */
    public function setSecure($secure = null)
    {
        // validation for constraint: boolean
        if (!is_null($secure) && !is_bool($secure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($secure)), __LINE__);
        }
        $this->Secure = $secure;
        return $this;
    }
    /**
     * Get ViaRouteType value
     * @return string
     */
    public function getViaRouteType()
    {
        return $this->ViaRouteType;
    }
    /**
     * Set ViaRouteType value
     * @uses \EnumType\EnumViaRouteType::valueIsValid()
     * @uses \EnumType\EnumViaRouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viaRouteType
     * @return \StructType\ViaRoute
     */
    public function setViaRouteType($viaRouteType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRouteType::valueIsValid($viaRouteType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $viaRouteType, implode(', ', \EnumType\EnumViaRouteType::getValidValues())), __LINE__);
        }
        $this->ViaRouteType = $viaRouteType;
        return $this;
    }
    /**
     * Get ViaRoutePlanningType value
     * @return string
     */
    public function getViaRoutePlanningType()
    {
        return $this->ViaRoutePlanningType;
    }
    /**
     * Set ViaRoutePlanningType value
     * @uses \EnumType\EnumViaRoutePlanningType::valueIsValid()
     * @uses \EnumType\EnumViaRoutePlanningType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $viaRoutePlanningType
     * @return \StructType\ViaRoute
     */
    public function setViaRoutePlanningType($viaRoutePlanningType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumViaRoutePlanningType::valueIsValid($viaRoutePlanningType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $viaRoutePlanningType, implode(', ', \EnumType\EnumViaRoutePlanningType::getValidValues())), __LINE__);
        }
        $this->ViaRoutePlanningType = $viaRoutePlanningType;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ViaRoute
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ViaRoute
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ViaRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
